/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.widgets;

import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.ViewElement;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.apache.commons.lang.StringUtils;

public class ListElement
extends ViewElement {
    public static final String KEY_VALUE = "value";
    public static final String KEY_SELECTED_ITEMS = "selectedItems";
    public static final String KEY_SELECTED_INDEX = "selectedIndex";
    private final transient JList theList;

    public ListElement(JList list, String name) {
        super(list, name);
        this.theList = list;
    }

    @Override
    public IViewElement set(String key, Object value) {
        if (StringUtils.isBlank((String)key)) {
            return this;
        }
        if (key.equalsIgnoreCase(KEY_VALUE)) {
            if (!(this.theList.getModel() instanceof DefaultListModel)) {
                return this;
            }
            DefaultListModel model = (DefaultListModel)this.theList.getModel();
            model.clear();
            if (value == null) {
                return this;
            }
            List list = (List)value;
            for (Object obj : list) {
                model.addElement(obj);
            }
        } else if (key.equalsIgnoreCase(KEY_SELECTED_INDEX)) {
            this.theList.setSelectedIndex((Integer)value);
        } else {
            super.set(key, value);
        }
        return this;
    }

    @Override
    public Object get(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_ITEMS)) {
            return this.theList.getSelectedValues();
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_INDEX)) {
            return this.theList.getSelectedIndex();
        }
        return super.get(key);
    }
}

