/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.widgets;

import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.ViewElement;
import java.awt.Color;
import java.awt.Component;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabbedPaneElement
extends ViewElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(TabbedPaneElement.class);
    public static final String KEY_SELECTED_INDEX = "selected-index";
    public static final String KEY_SELECTED_INDEX_NAME = "selected-index-name";
    public static final String KEY_ICON = "icon";
    public static final String KEY_FOREGROUND_AT = "foreground-at";
    public static final String KEY_ENABLE_AT = "enable-at";
    private final transient JTabbedPane theComp;

    protected TabbedPaneElement(JTabbedPane tabPane, String name) {
        super(tabPane, name);
        this.theComp = tabPane;
    }

    @Override
    public IViewElement set(String key, Object value) {
        if (StringUtils.isBlank((String)key) || value == null) {
            return this;
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_INDEX)) {
            int index = Integer.parseInt(value.toString());
            try {
                this.theComp.setSelectedIndex(index);
            }
            catch (Exception exep) {
                LOGGER.error("TabbedPaneElement: Error setting view element", (Throwable)exep);
            }
        } else {
            super.set(key, value);
        }
        return this;
    }

    @Override
    public IViewElement mset(String key, Object ... values) {
        block17: {
            if (StringUtils.isBlank((String)key) || values == null) {
                return this;
            }
            if (key.equalsIgnoreCase(KEY_ICON)) {
                if (values.length < 2) {
                    return this;
                }
                int pos = (Integer)values[0];
                String path = values[1].toString();
                ImageIcon icon = null;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        cl = this.getClass().getClassLoader();
                    }
                    icon = new ImageIcon(Objects.requireNonNull(cl.getResource(path)));
                }
                catch (Exception cl) {
                    // empty catch block
                }
                try {
                    Component comp = this.theComp.getTabComponentAt(pos);
                    if (comp instanceof JLabel) {
                        ((JLabel)comp).setIcon(icon);
                        break block17;
                    }
                    this.theComp.setIconAt(pos, icon);
                }
                catch (Exception exception) {}
            } else if (key.equalsIgnoreCase(KEY_ENABLE_AT)) {
                if (values.length < 2) {
                    return this;
                }
                int pos = (Integer)values[0];
                boolean flag = Boolean.parseBoolean(values[1].toString());
                this.theComp.setEnabledAt(pos, flag);
            } else if (key.equalsIgnoreCase(KEY_FOREGROUND_AT)) {
                if (values.length < 2) {
                    return this;
                }
                int pos = (Integer)values[0];
                Component comp = this.theComp.getTabComponentAt(pos);
                if (comp instanceof JLabel) {
                    comp.setForeground((Color)values[1]);
                } else {
                    this.theComp.setForegroundAt(pos, (Color)values[1]);
                }
            }
        }
        return super.set(key, values);
    }

    @Override
    public Object get(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_INDEX)) {
            return this.theComp.getSelectedIndex();
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_INDEX_NAME)) {
            return this.theComp.getTitleAt(this.theComp.getSelectedIndex());
        }
        return super.get(key);
    }
}

