/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.widgets;

import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.VisualNotifyViewElement;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class TextElement
extends VisualNotifyViewElement {
    public static final String KEY_EDITABLE = "editable";
    public static final String KEY_TEXT = "text";
    public static final String KEY_SELECTED_VALUE = "selectedValue";
    public static final String KEY_SELECTED_TEXT = "selectedText";
    public static final String AXN_GRAB_FOCUS = "grabFocus";
    private final JTextComponent theComp;

    protected TextElement(JTextComponent comp, String name) {
        super(comp, name);
        this.theComp = comp;
    }

    @Override
    public IViewElement set(String key, Object value) {
        if (StringUtils.isEmpty((String)key) || value == null) {
            return this;
        }
        if (key.equalsIgnoreCase(KEY_EDITABLE)) {
            boolean flag = Boolean.parseBoolean(value.toString());
            this.theComp.setEditable(flag);
        } else if (key.equalsIgnoreCase(KEY_TEXT)) {
            this.theComp.setText(value.toString());
        } else {
            super.set(key, value);
        }
        return this;
    }

    @Override
    public Object get(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (key.equalsIgnoreCase(KEY_TEXT)) {
            return this.theComp.getText();
        }
        if (key.equalsIgnoreCase(KEY_SELECTED_VALUE) || key.equalsIgnoreCase(KEY_SELECTED_TEXT)) {
            return this.theComp.getSelectedText();
        }
        return super.get(key);
    }

    @Override
    public IViewElement call(String action) {
        if (StringUtils.isBlank((String)action)) {
            return this;
        }
        if (action.equalsIgnoreCase(AXN_GRAB_FOCUS)) {
            this.theComp.grabFocus();
        }
        return this;
    }
}

