/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.widgets;

import in.gov.uidai.litef.devapi.IViewElement;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;

public class ViewElement
implements IViewElement {
    public static final String KEY_ENABLE = "enable";
    public static final String KEY_VISIBLE = "visible";
    public static final String KEY_SHOWING = "showing";
    public static final String KEY_TOOLTIP = "tooltip";
    public static final String AXN_FOCUS = "focus";
    public static final String PREFIX_XPROP = "xprop.";
    private final transient JComponent theComp;

    protected ViewElement(JComponent comp, String name) {
        this.theComp = comp;
        this.theComp.setName(name);
    }

    @Override
    public IViewElement mset(String key, Object ... values) {
        return this;
    }

    @Override
    public IViewElement set(String key, Object value) {
        if (StringUtils.isNotBlank((String)key) && value != null) {
            if (key.equalsIgnoreCase(KEY_ENABLE)) {
                boolean flag = Boolean.parseBoolean(value.toString());
                this.theComp.setEnabled(flag);
            } else if (key.equalsIgnoreCase(KEY_VISIBLE)) {
                boolean flag = Boolean.parseBoolean(value.toString());
                this.theComp.setVisible(flag);
            } else if (key.equalsIgnoreCase(KEY_TOOLTIP)) {
                this.theComp.setToolTipText(value.toString());
            } else if (StringUtils.startsWithIgnoreCase((String)key, (String)PREFIX_XPROP)) {
                this.theComp.putClientProperty(key, value);
            }
        }
        return this;
    }

    @Override
    public Object get(String key) {
        if (StringUtils.isNotBlank((String)key)) {
            if (key.equalsIgnoreCase(KEY_ENABLE)) {
                return this.theComp.isEnabled();
            }
            if (key.equalsIgnoreCase(KEY_VISIBLE)) {
                return this.theComp.isVisible() && this.theComp.isShowing();
            }
            if (key.equalsIgnoreCase(KEY_SHOWING)) {
                return this.theComp.isShowing();
            }
            if (key.equalsIgnoreCase(KEY_TOOLTIP)) {
                return this.theComp.getToolTipText();
            }
            if (StringUtils.startsWithIgnoreCase((String)key, (String)PREFIX_XPROP)) {
                return this.theComp.getClientProperty(key);
            }
        }
        return null;
    }

    @Override
    public IViewElement call(String action) {
        if (StringUtils.isNotBlank((String)action) && action.equalsIgnoreCase(AXN_FOCUS)) {
            this.theComp.grabFocus();
        }
        return this;
    }
}

