/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.litef.widgets;

import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.ViewElement;
import in.gov.uidai.swing.notify.NotificationLocation;
import in.gov.uidai.swing.notify.NotificationOverlay;
import in.gov.uidai.swing.notify.NotificationPopup;
import java.awt.Point;
import javax.swing.JComponent;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class VisualNotifyViewElement
extends ViewElement {
    public static final String KEY_NOTIFY = "notify";
    public static final String VALUE_NOTIFY_INFO = "info";
    public static final String VALUE_NOTIFY_ERROR = "error";
    private final transient JComponent theComp;

    protected VisualNotifyViewElement(JComponent comp, String name) {
        super(comp, name);
        this.theComp = comp;
    }

    @Override
    public IViewElement mset(String key, Object ... values) {
        if (StringUtils.isBlank((String)key)) {
            return this;
        }
        if (key.equalsIgnoreCase(KEY_NOTIFY) && ArrayUtils.isNotEmpty((Object[])values)) {
            String value1 = ObjectUtils.defaultIfNull((Object)values[0], (Object)"").toString();
            if (StringUtils.isNotBlank((String)value1)) {
                if (value1.equalsIgnoreCase(VALUE_NOTIFY_ERROR)) {
                    NotificationOverlay.setError(this.theComp);
                    this.addFeedback(values);
                } else if (value1.equalsIgnoreCase(VALUE_NOTIFY_INFO)) {
                    NotificationOverlay.setInfo(this.theComp);
                    this.addFeedback(values);
                }
            } else {
                NotificationOverlay.clear(this.theComp);
                this.clearFeedback();
            }
            this.theComp.repaint();
        } else {
            super.mset(key, values);
        }
        return this;
    }

    private void addFeedback(Object[] values) {
        if (values.length <= 1) {
            return;
        }
        String value2 = ObjectUtils.defaultIfNull((Object)values[1], (Object)"").toString();
        if (StringUtils.isBlank((String)value2)) {
            return;
        }
        NotificationPopup.getToolTip(this.theComp).setToolTipText(value2, false);
        if (values.length == 3) {
            NotificationLocation location = (NotificationLocation)((Object)ObjectUtils.defaultIfNull((Object)values[2], (Object)((Object)NotificationLocation.BOTTOM)));
            NotificationPopup.getToolTip(this.theComp).setLocation(location);
        } else if (values.length == 4) {
            try {
                int ptx = Integer.parseInt(values[2].toString());
                int pty = Integer.parseInt(values[3].toString());
                NotificationPopup.getToolTip(this.theComp).setLocation(new Point(ptx, pty));
            }
            catch (Exception exep) {
                NotificationPopup.getToolTip(this.theComp).setLocation(NotificationLocation.BOTTOM);
            }
        } else {
            NotificationPopup.getToolTip(this.theComp).setLocation(NotificationLocation.BOTTOM);
        }
    }

    private void clearFeedback() {
        NotificationPopup.getToolTip(this.theComp).setToolTipText(null, false);
    }
}

