/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AudioPlayer.class);
    private static AudioPlayer instance;
    private final Map<String, Clip> clipMap = new HashMap<String, Clip>();

    public static synchronized AudioPlayer getInstance() {
        if (instance == null) {
            instance = new AudioPlayer();
        }
        return instance;
    }

    public synchronized void play(String sndPath) {
        Clip clip = null;
        if (this.clipMap.containsKey(sndPath.toLowerCase())) {
            clip = this.clipMap.get(sndPath.toLowerCase());
            clip.stop();
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            try {
                try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(cl.getResource(sndPath));){
                    clip = AudioSystem.getClip();
                    clip.open(audioInputStream);
                }
                this.clipMap.put(sndPath.toLowerCase(), clip);
            }
            catch (Exception e) {
                String errMsg = "unable to load sound file";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error(errMsg, (Throwable)e);
                }
                LOGGER.error(errMsg + e.getMessage());
            }
        }
        if (clip != null) {
            try {
                clip.setFramePosition(0);
                clip.start();
            }
            catch (Exception exep) {
                LOGGER.error("unable to play sound file", (Throwable)exep);
            }
        }
    }
}

