/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import in.gov.uidai.ec.icas.autosuggest.AutoSuggestCache;
import in.gov.uidai.swing.border.DashedBorder;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSuggestDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoSuggestDecorator.class);
    private JTextField textField;
    private String lookupKey;
    private JList suggestList;
    private DefaultListModel suggestModel;
    private JScrollPane suggestScroll;
    private Popup popup;
    private String delimiters;
    private byte[] delimChars;

    public AutoSuggestDecorator(JTextField field) {
        this.textField = field;
        this.lookupKey = "*none*";
        this.delimiters = " \t.;:[]{}|+,-1234567890@#$%&*()";
        this.delimChars = this.delimiters.getBytes();
        this.suggestModel = new DefaultListModel();
        this.suggestList = new JList(this.suggestModel);
        this.suggestList.getSelectionModel().setSelectionMode(1);
        this.suggestScroll = new JScrollPane(this.suggestList);
        this.suggestScroll.setBorder(new DashedBorder().dashInterval("1.2, 1.2").lineColor("#baba45").lineThickness(1.0f));
        this.suggestList.setBackground(Color.decode("#f5f5b5"));
        this.textField.addKeyListener(new KeyHandler());
        this.suggestList.addMouseListener(new ListMouseHandler());
        this.textField.addFocusListener(new FocusHandler());
    }

    public AutoSuggestDecorator name(String key) {
        this.lookupKey = key;
        return this;
    }

    public AutoSuggestDecorator delimiters(String delim) {
        this.delimiters = delim;
        this.delimChars = this.delimiters.getBytes();
        return this;
    }

    private String getWordBeforeCaret() {
        Document doc = this.textField.getDocument();
        int cpos = this.textField.getCaretPosition();
        try {
            String word;
            String text = doc.getText(0, cpos);
            int spos = this.lastIndexOf(text);
            if (spos < 0) {
                spos = 0;
            }
            if ((word = doc.getText(spos, cpos - spos)).length() > 0 && this.delimiters.indexOf(word.charAt(0)) >= 0) {
                word = word.substring(1);
            }
            return word.trim();
        }
        catch (Exception exep) {
            LOGGER.error("AutoSuggest : Error getting word before caret", (Throwable)exep);
            return null;
        }
    }

    private void replaceWordUnderCaret(String word) {
        int cpos = this.textField.getCaretPosition();
        String text = this.textField.getText();
        int spos = this.lastIndexOf(text, cpos);
        spos = spos < 0 ? 0 : ++spos;
        int epos = this.indexOf(text, cpos);
        if (epos < 0) {
            epos = text.length();
        }
        Document doc = this.textField.getDocument();
        try {
            doc.remove(spos, epos - spos);
            doc.insertString(spos, word, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int lastIndexOf(String text) {
        return this.lastIndexOf(text, text.length());
    }

    private int lastIndexOf(String text, int startPos) {
        byte[] textChars = text.getBytes();
        if (startPos >= textChars.length) {
            startPos = textChars.length - 1;
        }
        for (int i = startPos; i >= 0; --i) {
            for (byte delimChar : this.delimChars) {
                if (textChars[i] != delimChar) continue;
                return i;
            }
        }
        return -1;
    }

    private int indexOf(String text, int startPos) {
        byte[] textChars = text.getBytes();
        if (startPos < 0) {
            startPos = 0;
        }
        for (int i = startPos; i < textChars.length; ++i) {
            for (byte delimChar : this.delimChars) {
                if (textChars[i] != delimChar) continue;
                return i;
            }
        }
        return -1;
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            if (AutoSuggestDecorator.this.popup != null) {
                AutoSuggestDecorator.this.popup.hide();
                AutoSuggestDecorator.this.popup = null;
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (AutoSuggestDecorator.this.popup != null) {
                AutoSuggestDecorator.this.popup.hide();
                AutoSuggestDecorator.this.popup = null;
            }
            if (AutoSuggestDecorator.this.textField.hasFocus()) {
                return;
            }
            StringTokenizer strtok = new StringTokenizer(AutoSuggestDecorator.this.textField.getText(), AutoSuggestDecorator.this.delimiters, false);
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken().trim();
                if (token.length() <= 2) continue;
                AutoSuggestCache.getInstance().addEntry(AutoSuggestDecorator.this.lookupKey, token);
            }
        }
    }

    public class ListMouseHandler
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent evt) {
            if (AutoSuggestDecorator.this.popup != null) {
                String suggest = (String)AutoSuggestDecorator.this.suggestList.getSelectedValue();
                if (suggest != null) {
                    AutoSuggestDecorator.this.replaceWordUnderCaret(suggest);
                }
                AutoSuggestDecorator.this.popup.hide();
                AutoSuggestDecorator.this.popup = null;
            }
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            if (keyCode == 38 || keyCode == 40 || keyCode == 33 || keyCode == 34) {
                if (AutoSuggestDecorator.this.popup != null) {
                    AutoSuggestDecorator.this.suggestList.dispatchEvent(evt);
                }
                return;
            }
            char kchar = evt.getKeyChar();
            if (kchar == '\u001b') {
                if (AutoSuggestDecorator.this.popup != null) {
                    AutoSuggestDecorator.this.popup.hide();
                    AutoSuggestDecorator.this.popup = null;
                }
                evt.consume();
                return;
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            int length;
            String word;
            int keyCode = evt.getKeyCode();
            if (keyCode == 38 || keyCode == 40 || keyCode == 33 || keyCode == 34) {
                return;
            }
            char kchar = evt.getKeyChar();
            if (kchar == '\u001b') {
                return;
            }
            if (kchar == '\n') {
                if (AutoSuggestDecorator.this.popup != null) {
                    String suggest = (String)AutoSuggestDecorator.this.suggestList.getSelectedValue();
                    if (suggest != null) {
                        AutoSuggestDecorator.this.replaceWordUnderCaret(suggest);
                    }
                    AutoSuggestDecorator.this.popup.hide();
                    AutoSuggestDecorator.this.popup = null;
                }
                return;
            }
            if (AutoSuggestDecorator.this.popup != null) {
                AutoSuggestDecorator.this.popup.hide();
                AutoSuggestDecorator.this.popup = null;
            }
            if ((word = AutoSuggestDecorator.this.getWordBeforeCaret()) == null || word.length() == 0) {
                return;
            }
            List suggestions = AutoSuggestCache.getInstance().getSuggestedList(AutoSuggestDecorator.this.lookupKey, word);
            int n = length = suggestions != null ? suggestions.size() : 0;
            if (length == 0) {
                return;
            }
            if (length > 10) {
                length = 10;
            }
            AutoSuggestDecorator.this.suggestModel.clear();
            for (int i = 0; i < length; ++i) {
                AutoSuggestDecorator.this.suggestModel.addElement(suggestions.get(i));
            }
            AutoSuggestDecorator.this.suggestList.setVisibleRowCount(length);
            AutoSuggestDecorator.this.suggestList.setSelectedIndex(0);
            Point floc = AutoSuggestDecorator.this.textField.getLocationOnScreen();
            Point pt = AutoSuggestDecorator.this.textField.getCaret().getMagicCaretPosition();
            int popx = floc.x + (pt != null ? pt.x : 0);
            int popy = floc.y + AutoSuggestDecorator.this.textField.getHeight();
            AutoSuggestDecorator.this.popup = PopupFactory.getSharedInstance().getPopup(null, AutoSuggestDecorator.this.suggestScroll, popx, popy);
            AutoSuggestDecorator.this.popup.show();
        }
    }
}

