/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import in.gov.uidai.swing.border.DashedBorder;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class CapitalizeDecorator {
    private static final String DELIMITERS = " \t.-,()[]!@#$%^&*?/;:'\"\\";
    private JList suggestList;
    private DefaultListModel suggestModel;
    private JScrollPane suggestScroll;
    private Popup popup;
    private JTextField textField;
    private boolean noReplace;

    public CapitalizeDecorator(JTextField tf) {
        this.textField = tf;
        this.textField.setInputVerifier(new _InputVerifier());
        this.textField.addKeyListener(new _KeyHandler());
        this.suggestModel = new DefaultListModel();
        this.suggestList = new JList(this.suggestModel);
        this.suggestList.getSelectionModel().setSelectionMode(1);
        this.suggestList.setBackground(Color.decode("#f5f5b5"));
        this.suggestList.addMouseListener(new _ListMouseHandler());
        this.suggestScroll = new JScrollPane(this.suggestList);
        DashedBorder border = new DashedBorder().dashInterval("1.2, 1.2").lineColor("#baba45").lineThickness(1.0f);
        this.suggestScroll.setBorder(new TitledBorder(border, " Capitalize to: "));
    }

    private String[] suggest(String input) {
        ArrayList<StringBuilder> result = new ArrayList<StringBuilder>();
        result.add(new StringBuilder());
        StringTokenizer strtok = new StringTokenizer(input, DELIMITERS, true);
        String[] parts = new String[strtok.countTokens()];
        int idx = 0;
        while (strtok.hasMoreTokens()) {
            parts[idx++] = strtok.nextToken();
        }
        for (int i = 0; i < parts.length; ++i) {
            Object sbsnaps;
            if (StringUtils.containsAny((String)parts[i], (String)DELIMITERS)) {
                for (StringBuilder stringBuilder : result) {
                    stringBuilder.append(parts[i]);
                }
                continue;
            }
            if (parts[i].length() == 1) {
                sbsnaps = result.toArray(new StringBuilder[result.size()]);
                result.clear();
                for (Object sb : sbsnaps) {
                    result.add(new StringBuilder(((StringBuilder)sb).toString()).append(parts[i].toUpperCase()));
                }
                if (i >= parts.length - 1 || StringUtils.containsAny((String)parts[i + 1], (String)",. ")) continue;
                for (Object sb : sbsnaps) {
                    result.add(new StringBuilder(((StringBuilder)sb).toString()).append(parts[i].toUpperCase()).append('.'));
                }
                continue;
            }
            if (StringUtils.isAllUpperCase((String)parts[i])) {
                sbsnaps = result.toArray(new StringBuilder[result.size()]);
                result.clear();
                String string = WordUtils.capitalizeFully((String)parts[i]);
                for (Object sb : sbsnaps) {
                    result.add(new StringBuilder(((StringBuilder)sb).toString()).append(string));
                }
                continue;
            }
            for (StringBuilder stringBuilder : result) {
                stringBuilder.append(WordUtils.capitalizeFully((String)parts[i]));
            }
        }
        String[] resultStrs = new String[result.size()];
        for (int i = 0; i < resultStrs.length; ++i) {
            resultStrs[i] = ((StringBuilder)result.get(i)).toString();
        }
        return resultStrs;
    }

    private void replaceWithListSelection() {
        if (this.popup != null) {
            String suggest = (String)this.suggestList.getSelectedValue();
            if (suggest != null) {
                this.textField.setText(suggest);
                this.noReplace = true;
            }
            this.popup.hide();
            this.popup = null;
        }
    }

    private class _InputVerifier
    extends InputVerifier {
        private _InputVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf;
            String text;
            if (CapitalizeDecorator.this.popup != null) {
                CapitalizeDecorator.this.replaceWithListSelection();
            }
            if (StringUtils.isBlank((String)(text = (tf = (JTextField)comp).getText()))) {
                CapitalizeDecorator.this.noReplace = false;
                return true;
            }
            String[] suggestions = CapitalizeDecorator.this.suggest(CapitalizeDecorator.this.textField.getText());
            if (suggestions.length == 0) {
                CapitalizeDecorator.this.noReplace = false;
                return true;
            }
            if (suggestions.length == 1) {
                tf.setText(suggestions[0]);
                CapitalizeDecorator.this.noReplace = false;
                return true;
            }
            CapitalizeDecorator.this.suggestModel.clear();
            if (CapitalizeDecorator.this.noReplace) {
                CapitalizeDecorator.this.noReplace = false;
                return true;
            }
            String longestStr = "012345678901234567";
            for (String suggestion : suggestions) {
                CapitalizeDecorator.this.suggestModel.addElement(suggestion);
                if (longestStr.length() >= suggestion.length()) continue;
                longestStr = suggestion;
            }
            CapitalizeDecorator.this.suggestList.setPrototypeCellValue(longestStr);
            int visibleRows = suggestions.length > 10 ? 10 : suggestions.length;
            CapitalizeDecorator.this.suggestList.setVisibleRowCount(visibleRows);
            CapitalizeDecorator.this.suggestList.setSelectedIndex(0);
            Point floc = CapitalizeDecorator.this.textField.getLocationOnScreen();
            Point pt = CapitalizeDecorator.this.textField.getCaret().getMagicCaretPosition();
            int popx = floc.x + (pt != null ? pt.x : 0);
            int popy = floc.y + CapitalizeDecorator.this.textField.getHeight();
            CapitalizeDecorator.this.popup = PopupFactory.getSharedInstance().getPopup(null, CapitalizeDecorator.this.suggestScroll, popx, popy);
            CapitalizeDecorator.this.popup.show();
            return false;
        }
    }

    private class _ListMouseHandler
    extends MouseAdapter {
        private _ListMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            CapitalizeDecorator.this.replaceWithListSelection();
        }
    }

    private class _KeyHandler
    extends KeyAdapter {
        private _KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            if (keyCode == 38 || keyCode == 40 || keyCode == 33 || keyCode == 34) {
                if (CapitalizeDecorator.this.popup != null) {
                    CapitalizeDecorator.this.suggestList.dispatchEvent(evt);
                }
                return;
            }
            char kchar = evt.getKeyChar();
            if (kchar == '\u001b') {
                if (CapitalizeDecorator.this.popup != null) {
                    CapitalizeDecorator.this.popup.hide();
                    CapitalizeDecorator.this.popup = null;
                    CapitalizeDecorator.this.suggestList.setSelectedIndex(0);
                    CapitalizeDecorator.this.replaceWithListSelection();
                }
                return;
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            if (keyCode == 38 || keyCode == 40 || keyCode == 33 || keyCode == 34) {
                return;
            }
            char kchar = evt.getKeyChar();
            if (kchar == '\u001b') {
                return;
            }
            if (kchar == '\n') {
                CapitalizeDecorator.this.replaceWithListSelection();
                return;
            }
            if (CapitalizeDecorator.this.popup != null) {
                CapitalizeDecorator.this.popup.hide();
                CapitalizeDecorator.this.popup = null;
            }
        }
    }
}

