/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import in.gov.uidai.swing.painter.LinearGradientBackground;
import in.gov.uidai.swing.util.UidSwingUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.lang.StringUtils;

public class DropDownToggleButton
extends JButton {
    private LinearGradientBackground background;
    private JPopupMenu dropDown;
    private SelectionHandler selHandler;
    private boolean rolloverFlag;

    public DropDownToggleButton(String text, String iconPath) {
        this(text, iconPath, null);
    }

    public DropDownToggleButton(String text, String iconPath, String selIconPath) {
        this.setText(text);
        this.setIcon(UidSwingUtilities.loadIcon(iconPath));
        if (StringUtils.isNotBlank((String)selIconPath)) {
            this.setRolloverIcon(UidSwingUtilities.loadIcon(selIconPath));
        }
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalAlignment(0);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Insets insets = this.getInsets();
        int width = Math.max(fm.stringWidth(text) + insets.left + insets.right, 48);
        this.setPreferredSize(new Dimension(width, 77));
        this.setCursor(new Cursor(12));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(false);
        this.setOpaque(false);
        this.dropDown = new JPopupMenu();
        this.addActionListener(new PopupHandler());
        this.addMouseListener(new RolloverHandler());
        this.selHandler = new SelectionHandler();
        this.background = new LinearGradientBackground().borderSize(1.0f).gradientColors("#000000, #000000").gradientStops("0, 1").direction(1).roundingSize(7, 7);
    }

    public JMenuItem addMenuItem(String text, String iconPath) {
        Icon icon = UidSwingUtilities.loadIcon(iconPath);
        JMenuItem result = new JMenuItem(text, icon);
        this.dropDown.add(result);
        result.addActionListener(this.selHandler);
        return result;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Insets insets = this.getInsets();
        int width = Math.max(fm.stringWidth(text) + insets.left + insets.right, 48);
        this.setPreferredSize(new Dimension(width, 77));
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.rolloverFlag) {
            this.background.doPaint(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
    }

    private class RolloverHandler
    extends MouseAdapter {
        private RolloverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            DropDownToggleButton.this.rolloverFlag = true;
            DropDownToggleButton.this.setForeground(Color.WHITE);
            DropDownToggleButton.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            DropDownToggleButton.this.rolloverFlag = false;
            DropDownToggleButton.this.setForeground(Color.BLACK);
            DropDownToggleButton.this.repaint();
        }
    }

    private class SelectionHandler
    implements ActionListener {
        private SelectionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            DropDownToggleButton.this.setSelected(true);
        }
    }

    private class PopupHandler
    implements ActionListener {
        private PopupHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (DropDownToggleButton.this.dropDown.getComponentCount() < 0) {
                return;
            }
            int xpos = DropDownToggleButton.this.getWidth() - DropDownToggleButton.this.getWidth();
            int ypos = DropDownToggleButton.this.getHeight();
            DropDownToggleButton.this.dropDown.show(DropDownToggleButton.this, xpos, ypos);
        }
    }
}

