/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import in.gov.uidai.swing.ZeroAsEmptyMaskFormatter;
import in.gov.uidai.swing.notify.NotificationOverlay;
import in.gov.uidai.swing.notify.NotificationPopup;
import java.math.BigInteger;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EidUidFieldBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EidUidFieldBuilder.class);

    private EidUidFieldBuilder() {
    }

    public static JFormattedTextField createUidField() {
        MaskFormatter fmt1 = new MaskFormatter();
        ZeroAsEmptyMaskFormatter fmt2 = new ZeroAsEmptyMaskFormatter();
        fmt1.setPlaceholderCharacter('0');
        fmt2.setPlaceholderCharacter('0');
        fmt1.setValueContainsLiteralCharacters(false);
        fmt2.setValueContainsLiteralCharacters(false);
        try {
            fmt1.setMask("####-####-####");
            fmt2.setMask("####-####-####");
        }
        catch (Exception exep) {
            LOGGER.error(exep.toString(), (Throwable)exep);
        }
        DefaultFormatterFactory dff = new DefaultFormatterFactory(fmt1, fmt2, fmt1);
        JFormattedTextField fmtField = new JFormattedTextField(dff);
        fmtField.putClientProperty("watermark-text", "0000-0000-0000");
        new _FormattedIdReset(fmtField);
        return fmtField;
    }

    public static JFormattedTextField createEid1Field() {
        MaskFormatter fmt1 = new MaskFormatter();
        ZeroAsEmptyMaskFormatter fmt2 = new ZeroAsEmptyMaskFormatter();
        fmt1.setPlaceholderCharacter('0');
        fmt2.setPlaceholderCharacter('0');
        fmt1.setValueContainsLiteralCharacters(false);
        fmt2.setValueContainsLiteralCharacters(false);
        try {
            fmt1.setMask("####-#####-#####");
            fmt2.setMask("####-#####-#####");
        }
        catch (Exception exep) {
            LOGGER.error(exep.toString(), (Throwable)exep);
        }
        DefaultFormatterFactory dff = new DefaultFormatterFactory(fmt1, fmt2, fmt1);
        JFormattedTextField fmtField = new JFormattedTextField(dff);
        fmtField.putClientProperty("watermark-text", "0000-00000-00000");
        new _FormattedIdReset(fmtField);
        return fmtField;
    }

    public static JFormattedTextField createEid2Field() {
        MaskFormatter fmt1 = new MaskFormatter();
        ZeroAsEmptyMaskFormatter fmt2 = new ZeroAsEmptyMaskFormatter();
        fmt1.setPlaceholderCharacter('0');
        fmt2.setPlaceholderCharacter('0');
        fmt1.setValueContainsLiteralCharacters(false);
        fmt2.setValueContainsLiteralCharacters(false);
        try {
            fmt1.setMask("##/##/####/##/##/##");
            fmt2.setMask("##/##/####/##/##/##");
        }
        catch (Exception exep) {
            LOGGER.error(exep.toString(), (Throwable)exep);
        }
        DefaultFormatterFactory dff = new DefaultFormatterFactory(fmt1, fmt2, fmt1);
        JFormattedTextField fmtField = new JFormattedTextField(dff);
        fmtField.putClientProperty("watermark-text", "dd/MM/yyyy/hh/mm/ss");
        new _FormattedIdReset(fmtField);
        return fmtField;
    }

    private static class _FormattedIdReset
    implements DocumentListener {
        private final JFormattedTextField theComp;

        public _FormattedIdReset(JFormattedTextField comp) {
            this.theComp = comp;
            this.theComp.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            this.checkAndClear();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.checkAndClear();
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.checkAndClear();
        }

        private void checkAndClear() {
            try {
                String value = (String)this.theComp.getValue();
                if (StringUtils.isBlank((String)value)) {
                    return;
                }
                if (new BigInteger(value).equals(BigInteger.ZERO)) {
                    return;
                }
            }
            catch (Exception exep) {
                LOGGER.error(exep.toString(), (Throwable)exep);
            }
            NotificationOverlay.clear(this.theComp);
            NotificationPopup.getToolTip(this.theComp).setToolTipText(null, false);
        }
    }
}

