/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ExplicitFocusPath {
    private String name;
    private List<Object> nestedElements;
    private ExplicitFocusPath parent;

    public ExplicitFocusPath(String name) {
        this.name = name;
        this.nestedElements = new ArrayList<Object>();
    }

    public void clear() {
        this.nestedElements.clear();
    }

    public ExplicitFocusPath getParent() {
        return this.parent;
    }

    public void add(Component comp) {
        this.nestedElements.add(comp);
    }

    public void add(ExplicitFocusPath path) {
        this.nestedElements.add(path);
        path.parent = this;
    }

    public void add(Component comp, int pos) {
        this.addAtImpl(comp, pos);
    }

    public void add(ExplicitFocusPath path, int pos) {
        this.addAtImpl(path, pos);
    }

    public void add(String parent, Component comp) {
        this.addNestedImpl(parent, comp);
    }

    public void add(String parent, ExplicitFocusPath path) {
        this.addNestedImpl(parent, path);
    }

    public Component getNext(Component comp) {
        ExplicitFocusPath cPath = this.findContainingPath(comp);
        if (cPath == null) {
            return null;
        }
        return cPath.findNextFromPath(comp);
    }

    public Component getPrevious(Component comp) {
        ExplicitFocusPath cPath = this.findContainingPath(comp);
        if (cPath == null) {
            return null;
        }
        return cPath.findPreviousFromPath(comp);
    }

    public Component getFirst() {
        if (this.nestedElements.isEmpty()) {
            return null;
        }
        Object next = this.nestedElements.get(0);
        if (next instanceof Component) {
            return (Component)next;
        }
        ExplicitFocusPath path = (ExplicitFocusPath)next;
        if (path != null) {
            return path.getFirst();
        }
        return null;
    }

    public Component getLast() {
        if (this.nestedElements.isEmpty()) {
            return null;
        }
        Object last = this.nestedElements.get(this.nestedElements.size() - 1);
        if (last instanceof Component) {
            return (Component)last;
        }
        ExplicitFocusPath path = (ExplicitFocusPath)last;
        if (path != null) {
            return path.getLast();
        }
        return null;
    }

    private void addNestedImpl(String name, Object obj) {
        if (StringUtils.equalsIgnoreCase((String)this.name, (String)name)) {
            this.nestedElements.add(obj);
            if (obj instanceof ExplicitFocusPath) {
                ((ExplicitFocusPath)obj).parent = this;
            }
            return;
        }
        for (Object item : this.nestedElements) {
            if (!(item instanceof ExplicitFocusPath)) continue;
            ExplicitFocusPath path = (ExplicitFocusPath)item;
            path.addNestedImpl(name, obj);
        }
    }

    private void addAtImpl(Object obj, int pos) {
        if (pos < 0) {
            this.nestedElements.add(0, obj);
        } else if (pos >= this.nestedElements.size()) {
            this.nestedElements.add(obj);
        } else {
            this.nestedElements.add(pos, obj);
        }
    }

    private ExplicitFocusPath findContainingPath(Component comp) {
        int pos = this.nestedElements.indexOf(comp);
        if (pos >= 0) {
            return this;
        }
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ExplicitFocusPath path;
            ExplicitFocusPath result;
            if (!(this.nestedElements.get(i) instanceof ExplicitFocusPath) || (result = (path = (ExplicitFocusPath)this.nestedElements.get(i)).findContainingPath(comp)) == null) continue;
            return result;
        }
        return null;
    }

    private Component findNextFromPath(Object item) {
        int pos = this.nestedElements.indexOf(item);
        if (pos >= this.nestedElements.size() - 1) {
            ExplicitFocusPath pPath = this.getParent();
            if (pPath == null) {
                return null;
            }
            return pPath.findNextFromPath(this);
        }
        Object nextObj = this.nestedElements.get(pos + 1);
        if (nextObj instanceof Component) {
            return (Component)nextObj;
        }
        ExplicitFocusPath downPath = (ExplicitFocusPath)nextObj;
        if (downPath != null) {
            return downPath.getFirst();
        }
        return null;
    }

    private Component findPreviousFromPath(Object item) {
        int pos = this.nestedElements.indexOf(item);
        if (pos == 0) {
            ExplicitFocusPath pPath = this.getParent();
            if (pPath == null) {
                return null;
            }
            return pPath.findPreviousFromPath(this);
        }
        Object prevObj = this.nestedElements.get(pos - 1);
        if (prevObj instanceof Component) {
            return (Component)prevObj;
        }
        ExplicitFocusPath downPath = (ExplicitFocusPath)prevObj;
        if (downPath != null) {
            return downPath.getLast();
        }
        return null;
    }
}

