/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import in.gov.uidai.swing.ExplicitFocusPath;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitFocusTraversalPolicy
extends FocusTraversalPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplicitFocusTraversalPolicy.class);
    private ExplicitFocusPath focusPath;

    public ExplicitFocusTraversalPolicy(Container target) {
        this(target, true);
    }

    public ExplicitFocusTraversalPolicy(Container target, boolean isRoot) {
        target.setFocusTraversalPolicy(this);
        this.focusPath = new ExplicitFocusPath("root");
        target.setFocusTraversalPolicyProvider(true);
        target.setFocusCycleRoot(isRoot);
    }

    public ExplicitFocusTraversalPolicy addComponent(Component comp) {
        this.focusPath.add(comp);
        return this;
    }

    public ExplicitFocusTraversalPolicy addComponent(Component comp, int pos) {
        this.focusPath.add(comp, pos);
        return this;
    }

    public ExplicitFocusTraversalPolicy addNested(ExplicitFocusPath path) {
        this.focusPath.add(path);
        return this;
    }

    public ExplicitFocusTraversalPolicy addNested(ExplicitFocusPath path, int pos) {
        this.focusPath.add(path, pos);
        return this;
    }

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        try {
            Component comp = this.focusPath.getNext(aComponent);
            if (comp != null && !this.accept(comp)) {
                return this.getComponentAfter(aContainer, comp);
            }
            return comp;
        }
        catch (Throwable th) {
            LOGGER.error("Error in getting component after", th);
            return null;
        }
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        try {
            Component comp = this.focusPath.getPrevious(aComponent);
            if (comp != null && !this.accept(comp)) {
                return this.getComponentBefore(aContainer, comp);
            }
            return comp;
        }
        catch (Throwable th) {
            LOGGER.error("Error getting component before", th);
            return null;
        }
    }

    @Override
    public Component getDefaultComponent(Container aContainer) {
        Component comp = this.focusPath.getFirst();
        if (!this.accept(comp)) {
            comp = this.getComponentAfter(aContainer, comp);
        }
        return comp;
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        return this.focusPath.getFirst();
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        return this.focusPath.getLast();
    }

    private boolean accept(Component aComponent) {
        if (!aComponent.isEnabled()) {
            return false;
        }
        if (!aComponent.isVisible()) {
            return false;
        }
        if (!aComponent.isFocusable()) {
            return false;
        }
        return aComponent.isShowing();
    }
}

