/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import org.apache.commons.lang.StringUtils;

public class ImageArea
extends JLabel {
    private int width;
    private int height;

    public ImageArea() {
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    public ImageArea(String imageLoc) {
        this();
        this.setImage(imageLoc);
    }

    public ImageArea(String imageLoc, int width, int height) {
        this();
        this.width = width;
        this.height = height;
        this.setImage(imageLoc);
    }

    public final void setImage(String imageLoc) {
        if (StringUtils.isBlank((String)imageLoc)) {
            this.setIcon(null);
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            if (this.width != 0 && this.height != 0) {
                this.setIcon(new ImageIcon(new ImageIcon(cl.getResource(imageLoc)).getImage().getScaledInstance(this.width, this.height, 4)));
            } else {
                this.setIcon(new ImageIcon(cl.getResource(imageLoc)));
            }
        }
        catch (Exception exep) {
            this.setBorder(new LineBorder(Color.RED, 1));
            this.setText("<html>image not found: <b>" + imageLoc);
        }
    }
}

