/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;

public final class ImageIconCache {
    private static final ImageIconCache theInst = new ImageIconCache();
    private final Map<String, ImageIcon> iconMap = new HashMap<String, ImageIcon>();

    private ImageIconCache() {
    }

    public static final ImageIconCache getInst() {
        return theInst;
    }

    public void addIcon(String name, String path) {
        this.addIcon(name, path, (ClassLoader)null);
    }

    public void addIcon(String name, String path, Class<?> refCls) {
        this.addIcon(name, path, refCls.getClassLoader());
    }

    public void addIcon(String name, String path, ClassLoader cl) {
        if (StringUtils.isBlank((String)name)) {
            return;
        }
        if (this.iconMap.containsKey(name.toLowerCase())) {
            return;
        }
        ClassLoader cld = cl;
        if (cld == null) {
            cld = Thread.currentThread().getContextClassLoader();
        }
        if (cld == null) {
            cld = this.getClass().getClassLoader();
        }
        try {
            ImageIcon icon = new ImageIcon(cld.getResource(path));
            this.iconMap.put(name.toLowerCase(), icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ImageIcon getIcon(String id) {
        if (this.iconMap.containsKey(id = id.toLowerCase())) {
            return this.iconMap.get(id);
        }
        String key = id.replace('\\', '_').replace('/', '_').replace(':', '_');
        this.addIcon(key, id);
        return this.iconMap.get(key);
    }
}

