/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class NucleusLayout
implements LayoutManager2 {
    public static final String CENTER = "center";
    public static final String MIDDLE = "center";
    private Component centerComp;
    private final List<Component> sideComps = new ArrayList<Component>();
    private final int hgap;
    private final int vgap;

    public NucleusLayout() {
        this.hgap = 0;
        this.vgap = 0;
    }

    public NucleusLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            this.sideComps.add(comp);
        } else if (constraints.toString().equalsIgnoreCase("center")) {
            this.centerComp = comp;
        } else {
            this.sideComps.add(comp);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        int totalWidth = 0;
        if (this.centerComp != null && this.centerComp.isVisible()) {
            totalWidth += this.centerComp.getMaximumSize().width;
        }
        if (!this.sideComps.isEmpty()) {
            totalWidth += this.hgap;
        }
        int sideWidth = 0;
        for (Component comp : this.sideComps) {
            if (!comp.isVisible()) continue;
            sideWidth = Math.max(sideWidth, comp.getMaximumSize().width);
        }
        totalWidth += sideWidth;
        int totalHeight = 0;
        if (this.centerComp != null && this.centerComp.isVisible()) {
            totalHeight += this.centerComp.getMaximumSize().height;
        }
        int sideHeight = 0;
        for (Component comp : this.sideComps) {
            if (!comp.isVisible()) continue;
            sideHeight += comp.getMaximumSize().height;
            sideHeight += this.vgap;
        }
        sideHeight = Math.max(sideHeight - this.vgap, 0);
        totalHeight = Math.max(totalHeight, sideHeight);
        Insets insets = target.getInsets();
        return new Dimension(totalWidth + insets.left + insets.right, totalHeight + insets.top + insets.bottom);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name == null) {
            this.sideComps.add(comp);
        } else if (name.equalsIgnoreCase("center")) {
            this.centerComp = comp;
        } else {
            this.sideComps.add(comp);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        int totalWidth = 0;
        if (this.centerComp != null && this.centerComp.isVisible()) {
            totalWidth += this.centerComp.getMinimumSize().width;
        }
        if (!this.sideComps.isEmpty()) {
            totalWidth += this.hgap;
        }
        int sideWidth = 0;
        for (Component comp : this.sideComps) {
            if (!comp.isVisible()) continue;
            sideWidth = Math.max(sideWidth, comp.getMinimumSize().width);
        }
        totalWidth += sideWidth;
        int totalHeight = 0;
        if (this.centerComp != null && this.centerComp.isVisible()) {
            totalHeight += this.centerComp.getMinimumSize().height;
        }
        int sideHeight = 0;
        for (Component comp : this.sideComps) {
            if (!comp.isVisible()) continue;
            sideHeight += comp.getMinimumSize().height;
            sideHeight += this.vgap;
        }
        sideHeight = Math.max(sideHeight - this.vgap, 0);
        totalHeight = Math.max(totalHeight, sideHeight);
        Insets insets = target.getInsets();
        return new Dimension(totalWidth + insets.left + insets.right, totalHeight + insets.top + insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        int totalWidth = 0;
        if (this.centerComp != null && this.centerComp.isVisible()) {
            totalWidth += this.centerComp.getPreferredSize().width;
            totalWidth += this.hgap;
        }
        if (!this.sideComps.isEmpty()) {
            totalWidth += this.hgap;
        }
        int sideWidth = 0;
        for (Component comp : this.sideComps) {
            if (!comp.isVisible()) continue;
            sideWidth = Math.max(sideWidth, comp.getPreferredSize().width);
        }
        totalWidth += sideWidth;
        int totalHeight = 0;
        if (this.centerComp != null && this.centerComp.isVisible()) {
            totalHeight += this.centerComp.getPreferredSize().height;
        }
        int sideHeight = 0;
        for (Component comp : this.sideComps) {
            if (!comp.isVisible()) continue;
            sideHeight += comp.getPreferredSize().height;
            sideHeight += this.vgap;
        }
        sideHeight = Math.max(sideHeight - this.vgap, 0);
        totalHeight = Math.max(totalHeight, sideHeight);
        Insets insets = target.getInsets();
        return new Dimension(totalWidth + insets.left + insets.right, totalHeight + insets.top + insets.bottom);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.centerComp.equals(comp)) {
            this.centerComp = null;
        } else {
            this.sideComps.remove(comp);
        }
    }

    @Override
    public void layoutContainer(Container target) {
        if (this.centerComp != null && this.centerComp.isVisible()) {
            this.layoutWithNucleus(target);
        } else {
            this.layoutNoNucleus(target);
        }
    }

    private void layoutNoNucleus(Container target) {
        Insets insets = target.getInsets();
        int mainWidth = target.getWidth() - insets.left - insets.right;
        int mainHeight = target.getHeight() - insets.top - insets.bottom;
        int totalCompWidth = 0;
        for (Component comp : this.sideComps) {
            if (!comp.isVisible() || comp.getMinimumSize().height > mainHeight) continue;
            totalCompWidth += comp.getPreferredSize().width;
            totalCompWidth += this.hgap;
        }
        totalCompWidth = Math.max(totalCompWidth - this.hgap, 0);
        int posx = insets.left;
        if (totalCompWidth < mainWidth) {
            posx = (mainWidth - totalCompWidth) / 2;
        }
        for (Component comp : this.sideComps) {
            if (!comp.isVisible() || comp.getMinimumSize().height > mainHeight) continue;
            int posy = insets.top;
            int compHeight = mainHeight;
            if (comp.getPreferredSize().height < mainHeight) {
                posy = (mainHeight - comp.getPreferredSize().height) / 2;
                compHeight = comp.getPreferredSize().height;
            }
            comp.setSize(comp.getPreferredSize().width, compHeight);
            if (posx + comp.getPreferredSize().width > mainWidth) {
                posx = target.getWidth() + 1;
            }
            comp.setLocation(posx, posy);
            posx += comp.getPreferredSize().width;
            posx += this.hgap;
        }
        for (Component comp : this.sideComps) {
            if (!(comp instanceof JComponent)) continue;
            JComponent jcomp = (JComponent)comp;
            jcomp.putClientProperty("minimized", false);
        }
    }

    private void layoutWithNucleus(Container target) {
        Insets insets = target.getInsets();
        int mainWidth = target.getWidth() - insets.left - insets.right;
        int mainHeight = target.getHeight() - insets.top - insets.bottom;
        int sideWidth = 0;
        for (Component comp : this.sideComps) {
            if (!comp.isVisible() || comp.getMinimumSize().width > mainWidth) continue;
            sideWidth = Math.max(sideWidth, comp.getMinimumSize().width);
        }
        sideWidth = Math.min(mainWidth, sideWidth);
        int centerWidth = mainWidth - sideWidth - this.hgap;
        centerWidth = Math.max(this.centerComp.getMinimumSize().width, centerWidth);
        int centerHeight = Math.max(mainHeight, this.centerComp.getMinimumSize().height);
        this.centerComp.setSize(centerWidth, centerHeight);
        if (centerHeight > mainHeight) {
            this.centerComp.setLocation(insets.left, target.getHeight() + 1);
        } else {
            this.centerComp.setLocation(insets.left, insets.top);
        }
        int posy = insets.top;
        for (Component comp : this.sideComps) {
            if (!comp.isVisible() || comp.getMinimumSize().width > sideWidth) continue;
            if (posy + comp.getMinimumSize().height > mainHeight) {
                posy = target.getHeight() + 1;
            }
            comp.setSize(sideWidth, comp.getMinimumSize().height);
            comp.setLocation(insets.left + centerWidth + this.hgap, posy);
            posy += comp.getMinimumSize().height;
            posy += this.vgap;
        }
        for (Component comp : this.sideComps) {
            if (!(comp instanceof JComponent)) continue;
            JComponent jcomp = (JComponent)comp;
            jcomp.putClientProperty("minimized", true);
        }
    }
}

