/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import in.gov.uidai.swing.border.DashedBorder;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import javax.swing.JLabel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class PopupLabelDecorator {
    private JLabel target;
    private JLabel popLab;
    private Popup popup;
    private Timer exitTimer;
    private Border lineBorder;

    public static final void apply(JLabel label) {
        new PopupLabelDecorator(label);
    }

    private PopupLabelDecorator(JLabel label) {
        this.target = label;
        this.popLab = new JLabel();
        MouseHandler mh = new MouseHandler();
        this.target.addMouseListener(mh);
        this.target.addVetoableChangeListener(new ChangeHandler());
        this.popLab.addMouseListener(mh);
        this.exitTimer = new Timer(100, new DelayedExitHandler());
        this.exitTimer.setRepeats(false);
        this.lineBorder = new DashedBorder().lineColor("#baba45").lineThickness(1.0f).dashInterval("1.2,1.2");
        this.popLab.setOpaque(true);
        this.popLab.setBackground(Color.decode("#f5f5b5"));
    }

    private void prepareAndShowPopup() {
        if (this.popup != null && this.popLab.isShowing()) {
            return;
        }
        Font f = this.target.getFont();
        FontMetrics fm = this.target.getFontMetrics(f);
        int textWidth = fm.stringWidth(this.target.getText());
        int textHeight = fm.getHeight();
        if (textWidth <= this.target.getWidth() && textHeight < this.target.getHeight()) {
            return;
        }
        this.popLab.setFont(f);
        this.popLab.setText(this.target.getText());
        int targetHeight = this.target.getHeight();
        int padding = (targetHeight - textHeight - 2) / 2;
        if (padding > 0) {
            EmptyBorder border2 = new EmptyBorder(padding, 0, padding, 0);
            this.popLab.setBorder(new CompoundBorder(this.lineBorder, border2));
        } else {
            this.popLab.setBorder(this.lineBorder);
        }
        Point location = this.target.getLocationOnScreen();
        if (this.target.getComponentOrientation().equals(ComponentOrientation.RIGHT_TO_LEFT)) {
            location.x = location.x + this.target.getWidth() - textWidth;
        }
        if (padding <= 0) {
            --location.y;
        }
        this.popup = PopupFactory.getSharedInstance().getPopup(this.target, this.popLab, location.x, location.y);
        this.popup.show();
    }

    private class DelayedExitHandler
    implements ActionListener {
        private DelayedExitHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (PopupLabelDecorator.this.popup != null) {
                PopupLabelDecorator.this.popup.hide();
                PopupLabelDecorator.this.popup = null;
            }
        }
    }

    private class ChangeHandler
    implements VetoableChangeListener {
        private ChangeHandler() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) {
            if (PopupLabelDecorator.this.popup != null) {
                PopupLabelDecorator.this.popup.hide();
                PopupLabelDecorator.this.popup = null;
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            if (evt.getSource() == PopupLabelDecorator.this.popLab) {
                PopupLabelDecorator.this.exitTimer.stop();
            }
            PopupLabelDecorator.this.prepareAndShowPopup();
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            PopupLabelDecorator.this.exitTimer.start();
        }
    }
}

