/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import in.gov.uidai.ec.icas.util.OS;
import in.gov.uidai.litef.devapi.IEventContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;

public class StatusBarClock
extends JLabel {
    static long previousTime = 0L;
    static String currentTimeZoneId = "";
    private final SimpleDateFormat sdf;
    private final ScheduledExecutorService ticker;
    private final Date date;
    boolean isErrorMsgDisplayed = false;
    boolean isTimezoneErrorMsgDisplayed = false;
    IEventContext evtCtxt;

    public StatusBarClock(String format, int interval, IEventContext evtCtxt) {
        this.evtCtxt = evtCtxt;
        this.sdf = new SimpleDateFormat(format);
        this.date = new Date();
        this.ticker = Executors.newSingleThreadScheduledExecutor();
        this.ticker.scheduleAtFixedRate(new _RefreshTime(), 0L, interval, TimeUnit.MILLISECONDS);
    }

    private class _RefreshTime
    implements Runnable {
        private _RefreshTime() {
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            TimeZone.setDefault(null);
            System.setProperty("user.timezone", "");
            String TimeZoneId = TimeZone.getDefault().getID();
            String osSpecifiedTimeZoneID = null;
            if (OS.IsWindows()) {
                osSpecifiedTimeZoneID = "Asia/Calcutta";
            } else if (OS.IsLinux()) {
                osSpecifiedTimeZoneID = "Asia/Kolkata";
            }
            if (!(currentTimeZoneId.isEmpty() || TimeZoneId.equals(osSpecifiedTimeZoneID) || StatusBarClock.this.isTimezoneErrorMsgDisplayed)) {
                StatusBarClock.this.isTimezoneErrorMsgDisplayed = true;
                StatusBarClock.this.evtCtxt.fireGenericEvent("timeZoneChangeClosing", new Object[0]);
            }
            if (previousTime != 0L && Math.abs(currentTime - previousTime) > 60000L && !StatusBarClock.this.isErrorMsgDisplayed) {
                StatusBarClock.this.isErrorMsgDisplayed = true;
                StatusBarClock.this.evtCtxt.fireGenericEvent("timeChangeClosing", new Object[0]);
            }
            currentTimeZoneId = TimeZoneId;
            previousTime = currentTime;
            StatusBarClock.this.date.setTime(currentTime);
            StatusBarClock.this.setText(StatusBarClock.this.sdf.format(StatusBarClock.this.date));
        }
    }
}

