/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.gps.IGpsControl;
import in.gov.uidai.ec.service.gps.IGpsListener;
import in.gov.uidai.ec.service.gps.IGpsPreference;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusBarGPS
extends JLabel {
    private static final long serialVersionUID = -7236707395742617192L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusBarGPS.class);
    DecimalFormat df = new DecimalFormat("0000.000000");
    private IGpsControl gpsControl;
    private IGpsPreference gpsPref;
    private IOucDataStore oucDataStore;

    public void setGpsControl(IGpsControl gpsControl) {
        this.gpsControl = gpsControl;
    }

    public void setGpsPref(IGpsPreference gpsPref) {
        this.gpsPref = gpsPref;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public void init() {
        GpsInfo gpsInfo = new GpsInfo();
        try {
            gpsInfo = this.oucDataStore.getGpsInfo();
        }
        catch (IOException e) {
            LOGGER.error("Error connecting to OUC", (Throwable)e);
        }
        catch (StationInfoStoreException e) {
            LOGGER.error("Error fetching gps details from OUC", (Throwable)e);
        }
        this.setText(GeoData.convertCoords((float)gpsInfo.getLatitude().floatValue()), this.gpsPref.getLatBearing("N"), GeoData.convertCoords((float)gpsInfo.getLongitude().floatValue()), this.gpsPref.getLongBearing("E"), GeoData.COORD_FORMAT.format(gpsInfo.getAltitude()));
        IGpsListener gpsListener = new IGpsListener(){

            public void geoDataReceived(GeoData data) {
                float dlati = Float.parseFloat(data.getLatitude());
                float dlongi = Float.parseFloat(data.getLongitude());
                int decimalLengthLongitude = StatusBarGPS.this.df.format(dlongi).length() - 1;
                int decimalLengthlatitude = StatusBarGPS.this.df.format(dlati).length() - 1;
                if (decimalLengthLongitude == 10 && decimalLengthlatitude == 10) {
                    String latitude = data.getDMSLatitude();
                    String latBearing = data.getLatBearing();
                    String longitude = data.getDMSLongitude();
                    String longBearing = data.getLongBearing();
                    String altitude = data.getFormattedAltitude();
                    StatusBarGPS.this.setText(latitude, latBearing, longitude, longBearing, altitude);
                }
            }

            public void deviceRemoved() {
            }

            public void deviceConnected() {
            }
        };
        this.gpsControl.addGpsListener(gpsListener);
    }

    public void setText(String latitude, String latBearing, String longitude, String longBearing, String altitude) {
        this.setText("Location: " + latitude + " " + latBearing + "," + longitude + " " + longBearing + ":" + altitude + " m");
    }
}

