/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing;

import in.gov.uidai.swing.util.UidSwingUtilities;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JToggleButton;
import org.apache.commons.lang.StringUtils;

public class ToolBarButton
extends JToggleButton {
    public ToolBarButton(String text, String iconPath) {
        this(text, iconPath, null);
    }

    public ToolBarButton(String text, String iconPath, String selIconPath) {
        this.setText(text);
        this.setIcon(UidSwingUtilities.loadIcon(iconPath));
        if (StringUtils.isNotBlank((String)selIconPath)) {
            this.setSelectedIcon(UidSwingUtilities.loadIcon(selIconPath));
        }
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalAlignment(0);
        this.setCursor(new Cursor(12));
        this.setBorderPainted(false);
        this.setRolloverEnabled(false);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.resizeToText();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.resizeToText();
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    private void resizeToText() {
        String text = this.getText();
        if (text == null || text.length() == 0) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Insets insets = this.getInsets();
        int width = Math.max(fm.stringWidth(text) + insets.left + insets.right, 48);
        this.setPreferredSize(new Dimension(width, 77));
    }
}

