/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.BiometricsEvent;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio._BiometricsFocusTraversalPolicy;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class BiometricsFieldBase
extends TransparentBox {
    private final List<IBiometricsListener> listeners = new ArrayList<IBiometricsListener>();
    FocusAndMouseHandler fam;
    private IClientDeviceManager cdm;

    protected BiometricsFieldBase() {
        this.setBorder(new RoundedBorder().lineColor("#999999").lineThickness(1.0f).rounding(7, 7));
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new _BiometricsFocusTraversalPolicy());
        this.enableEvents(24L);
        this.fam = new FocusAndMouseHandler(this);
        this.addFocusListener(this.fam);
        this.addMouseListener(this.fam);
        this.setEnabled(true);
    }

    protected void disableGradientBg() {
        this.fam.disableGradientBg();
    }

    public final void addBiometricsListener(IBiometricsListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public final void removeBiometricsListener(IBiometricsListener l) {
        this.listeners.remove(l);
    }

    protected final IClientDeviceManager getClientDeviceManager() {
        return this.cdm;
    }

    public final void setClientDeviceManager(IClientDeviceManager cdm) {
        this.cdm = cdm;
    }

    protected final void fireCaptureStarted() {
        BiometricsEvent evt = new BiometricsEvent(this, 1, new String[0]);
        this.listeners.forEach(l -> l.captureStarted(evt));
    }

    protected final void fireCaptureStopped() {
        BiometricsEvent evt = new BiometricsEvent(this, 2, new String[0]);
        this.listeners.forEach(l -> l.captureStopped(evt));
    }

    protected final void fireCaptureForced() {
        BiometricsEvent evt = new BiometricsEvent(this, 3, new String[0]);
        this.listeners.forEach(l -> l.captureForced(evt));
    }

    protected final void fireSampleReceived(String ... attemptIds) {
        BiometricsEvent evt = new BiometricsEvent(this, 4, attemptIds);
        this.listeners.forEach(l -> l.sampleReceived(evt));
    }

    protected final void fireSampleDeleted(String ... attemptIds) {
        BiometricsEvent evt = new BiometricsEvent(this, 4, attemptIds);
        this.listeners.forEach(l -> l.sampleDeleted(evt));
    }

    protected final void fireComponentBusy() {
        BiometricsEvent evt = new BiometricsEvent(this, 7, new String[0]);
        this.listeners.forEach(l -> l.componentIsBusy(evt));
    }

    protected final void fireComponentReady() {
        BiometricsEvent evt = new BiometricsEvent(this, 6, new String[0]);
        this.listeners.forEach(l -> l.componentIsReady(evt));
    }

    private static class FocusAndMouseHandler
    extends MouseAdapter
    implements FocusListener {
        private final LinearGradientBackground blurBg;
        private final TransparentBox comp;
        private LinearGradientBackground focusBg;
        private boolean gradientBg = true;

        public FocusAndMouseHandler(TransparentBox comp) {
            this.comp = comp;
            this.focusBg = new LinearGradientBackground().borderSize(1.0f).direction(1).roundingSize(7, 7).gradientColors("#b7d4ed, #cae0f2, #e3eef8, #f8fbfd, #ffffff").gradientStops("0, 0.25, 0.5, 0.75, 1");
            this.blurBg = new LinearGradientBackground().borderSize(1.0f).direction(1).gradientColors("#eeeeee, #eeeeee").gradientStops("0, 1").roundingSize(7, 7);
            comp.setBackground(this.blurBg);
        }

        public void disableGradientBg() {
            this.gradientBg = false;
            this.focusBg = new LinearGradientBackground().borderSize(1.0f).direction(1).roundingSize(7, 7).gradientColors("#84a9d8, #84a9d8").gradientStops("0, 1");
        }

        @Override
        public void focusGained(FocusEvent evt) {
            this.comp.setBackground(this.comp.isEnabled() ? this.focusBg : this.blurBg);
            this.comp.repaint();
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (this.gradientBg) {
                this.comp.setBackground(this.blurBg);
                this.comp.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (this.comp.isEnabled()) {
                this.comp.requestFocusInWindow();
            }
        }
    }
}

