/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.capture;

import in.gov.uidai.ec.biometrics.device.CaptureRequest;
import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.device.DeviceInfo;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.IDeviceContext;
import in.gov.uidai.ec.biometrics.device.IGenericDeviceContext;
import in.gov.uidai.ec.biometrics.device.INonRDImageListener;
import in.gov.uidai.ec.biometrics.device.SampleFormatInfo;
import in.gov.uidai.ec.biometrics.device.VideoFormatInfo;
import in.gov.uidai.ec.biometrics.postcap.Acceptance;
import in.gov.uidai.ec.biometrics.postcap.BioxDataAnalyzer;
import in.gov.uidai.ec.biometrics.postcap.CaptureProcessorFactory;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.biometrics.postcap.IQSSProcessor;
import in.gov.uidai.ec.biometrics.postcap._FingerMismatchCounter;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.AudioPlayer;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.BiometricsFieldBase;
import in.gov.uidai.swing.bio.LabelAndMsgKeys;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureGroup;
import in.gov.uidai.swing.bio.capture.ISubCaptureContext;
import in.gov.uidai.swing.bio.capture._CaptureActionModel;
import in.gov.uidai.swing.bio.capture._CaptureCounters;
import in.gov.uidai.swing.bio.capture._SubCaptureField;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiometricsCaptureField
extends BiometricsFieldBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiometricsCaptureField.class);
    private static final String NAME_START_PANEL = "StartPanel";
    private static final String NAME_END_FORCE_PANEL = "EndForcePanel";
    private static final String TIP_NO_START = "Click to start capture";
    private static final String TIP_AFTER_START = "Click to stop capture";
    private final JLabel titleLabel;
    private final JLabel attemptLabel;
    private final CardLayout leftFlipLayout;
    private final JComponent leftControlBar;
    private final TransparentBox rightControlBar;
    private final _CaptureActionModel axnModel;
    private final _FingerMismatchCounter fingerMismatchCounter;
    private final BiometricPosition bioPos;
    private final DeviceImageHandler imgHandler;
    private final _CaptureCounters capCounters;
    private final List<_SubCaptureField> subFields;
    private final TransparentBox fieldArea;
    private final GridLayout maxLayout;
    private final GridLayout minLayout;
    private L10nDecorator ldeco;
    private BiometricsCaptureGroup bioGroup;
    private boolean qssEnableFlag;
    private AbstractPreviewPlayer player;
    private IBioxDataProvider bdp;
    private DeviceType devType;
    private IDeviceContext devCtxt;
    private long startTime;
    private long endTime;
    private long forceCaptureMinDelay;
    private boolean forcedCapture;
    private boolean ftcFlag;
    private boolean isDelete;
    private EnrollmentService enrollmentService;
    public JLabel uploadStatus;

    public BiometricsCaptureField(String title, BiometricPosition bpos, EnrollmentService ... enrollmentService) {
        this.accessibleContext = new AccessibleBiometricCapture();
        this.accessibleContext.setAccessibleName(title);
        this.capCounters = new _CaptureCounters();
        this.fingerMismatchCounter = new _FingerMismatchCounter();
        SubCaptureContext capCtxt = new SubCaptureContext();
        this.subFields = new ArrayList<_SubCaptureField>();
        this.bioPos = bpos;
        switch (this.bioPos) {
            case FACE: {
                this.devType = DeviceType.PHOTO;
                _SubCaptureField field = new _SubCaptureField(capCtxt, this.bioPos);
                field.setThumbToolTip(TIP_NO_START);
                field.addQssKeyBinding(this);
                this.subFields.add(field);
                break;
            }
            case LEFT_IRIS: 
            case RIGHT_IRIS: {
                this.devType = DeviceType.IRIS;
                _SubCaptureField field = new _SubCaptureField(capCtxt, this.bioPos);
                field.setThumbToolTip(TIP_NO_START);
                field.addQssKeyBinding(this);
                this.subFields.add(field);
                break;
            }
            case BOTH_IRIS: {
                this.devType = DeviceType.IRIS;
                _SubCaptureField field1 = new _SubCaptureField(capCtxt, BiometricPosition.LEFT_IRIS);
                field1.setThumbToolTip(TIP_NO_START);
                field1.addQssKeyBinding(this);
                _SubCaptureField field2 = new _SubCaptureField(capCtxt, BiometricPosition.RIGHT_IRIS);
                field2.setThumbToolTip(TIP_NO_START);
                field2.addQssKeyBinding(this);
                this.subFields.add(field1);
                this.subFields.add(field2);
                break;
            }
            case LEFT_SLAP: 
            case RIGHT_SLAP: 
            case BOTH_THUMBS: {
                this.devType = DeviceType.FINGERPRINT;
                _SubCaptureField field = new _SubCaptureField(capCtxt, this.bioPos);
                field.setThumbToolTip(TIP_NO_START);
                field.addQssKeyBinding(this);
                this.subFields.add(field);
                break;
            }
        }
        this.imgHandler = new DeviceImageHandler();
        this.axnModel = new _CaptureActionModel(this);
        TransparentBox startPanel = new TransparentBox(new FlowLayout(0, 0, 0));
        startPanel.add(this.axnModel.getStartButton());
        this.uploadStatus = new JLabel("\ue86c");
        this.uploadStatus.setFont(new Font("Material Icons", 0, 25));
        this.uploadStatus.setForeground(Color.decode("#BEC3C7"));
        this.uploadStatus.setHorizontalAlignment(0);
        this.uploadStatus.setToolTipText("Not uploaded");
        this.uploadStatus.setVisible(false);
        this.uploadStatus.setName("Bio-upload-status");
        startPanel.add(this.uploadStatus);
        TransparentBox endForcePanel = new TransparentBox(new FlowLayout(0, 0, 0));
        endForcePanel.add(this.axnModel.getEndButton());
        endForcePanel.add(this.axnModel.getForceButton());
        this.leftFlipLayout = new CardLayout();
        this.leftControlBar = new TransparentBox(this.leftFlipLayout);
        this.leftControlBar.add((Component)startPanel, NAME_START_PANEL);
        this.leftControlBar.add((Component)endForcePanel, NAME_END_FORCE_PANEL);
        this.rightControlBar = new TransparentBox(new FlowLayout(0, 0, 0));
        this.rightControlBar.add(this.axnModel.getPreviousButton());
        this.rightControlBar.add(this.axnModel.getNextButton());
        this.rightControlBar.add(this.axnModel.getDeleteButton());
        double[][] titleGuides = new double[][]{{-1.0, -2.0, -2.0, -2.0, -1.0}, {16.0}};
        TransparentBox titleBox = new TransparentBox(new TableLayout(titleGuides));
        titleBox.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.titleLabel = new JLabel();
        this.titleLabel.setText(title);
        this.attemptLabel = new JLabel();
        titleBox.add((Component)this.titleLabel, "1, 0, f, f");
        titleBox.add((Component)new JLabel(" :: "), "2, 0, f, f");
        titleBox.add((Component)this.attemptLabel, "3, 0, f, f");
        this.updateAttemptStatus();
        TransparentBox controlBar = new TransparentBox(new BorderLayout(0, 0));
        controlBar.add((Component)this.leftControlBar, "West");
        controlBar.add((Component)this.rightControlBar, "East");
        controlBar.add((Component)titleBox, "Center");
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)controlBar, "North");
        this.maxLayout = new GridLayout(1, this.subFields.size(), 5, 5);
        this.minLayout = new GridLayout(this.subFields.size(), 1, 5, 5);
        this.fieldArea = new TransparentBox(this.maxLayout);
        for (int i = this.subFields.size() - 1; i >= 0; --i) {
            this.fieldArea.add(this.subFields.get(i));
        }
        this.add((Component)this.fieldArea, "Center");
        this.addComponentListener(new FieldComponentHandler());
        this.setQSSEnabled(true);
        this.capCounters.stat();
        if (enrollmentService.length > 0) {
            this.enrollmentService = Arrays.stream(enrollmentService).findFirst().get();
            this.uploadStatus.setVisible(this.enrollmentService.isUniversalClientTrnx());
        }
    }

    public void addCaptureAttemptAdditionChangeListener(BiConsumer<BiometricPosition, CaptureAttempt> delegate) {
        this.subFields.forEach(field -> field.addCaptureAttemptAdditionChangeListeners(delegate));
    }

    public void addCaptureAttemptDeletionChangeListener(BiConsumer<BiometricPosition, CaptureAttempt> delegate) {
        this.subFields.forEach(field -> field.addCaptureAttemptDeletionChangeListeners(delegate));
    }

    public void addCaptureAttemptClearChangeListener(Consumer<BiometricPosition> delegate) {
        this.subFields.forEach(field -> field.addCaptureAttemptClearChangeListeners(delegate));
    }

    public void addBestCaptureAttemptChangeListeners(BiConsumer<BiometricPosition, CaptureAttempt> delegate) {
        this.subFields.forEach(field -> field.addBestCaptureAttemptChangeListeners(delegate));
    }

    public void localize(L10nDecorator deco) {
        String titleText = this.titleLabel.getText();
        deco.localize(this.titleLabel, (Object)titleText, new Object[0]);
        this.axnModel.localize(deco);
        this.subFields.forEach(subField -> subField.localize(deco));
        this.ldeco = deco;
        this.updateAttemptStatus();
    }

    public void setQSSEnabled(boolean flag) {
        this.subFields.forEach(field -> field.setQSSEnabled(flag));
        this.qssEnableFlag = flag;
    }

    public void addQSSActionListener(ActionListener l) {
        this.addQSSActionListener(l, null);
    }

    public void addQSSActionListener(ActionListener l, BiometricPosition bpos) {
        if (bpos == null) {
            this.subFields.forEach(field -> field.addQSSActionListener(l));
        } else {
            _SubCaptureField field2 = this.getField(bpos);
            if (field2 != null) {
                field2.addQSSActionListener(l);
            }
        }
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void setPreviewPlayer(AbstractPreviewPlayer player) {
        this.player = player;
        this.player.setVisible(false);
        this.axnModel.applyForceMouseListener(player);
    }

    public final void setBioxDataProvider(IBioxDataProvider provider) {
        this.bdp = provider;
    }

    public void setMaxAttempts(int count) {
        this.capCounters.setMaxAttempts(count);
        this.capCounters.stat();
        this.updateAttemptStatus();
    }

    public _FingerMismatchCounter getFingerMismatchCounter() {
        return this.fingerMismatchCounter;
    }

    public void setForceCaptureMinDelay(long forceCaptureMinDelay) {
        this.forceCaptureMinDelay = forceCaptureMinDelay;
    }

    public List<CaptureAttempt> getCaptureAttempts() {
        return this.getCaptureAttempts(null);
    }

    public List<CaptureAttempt> getCaptureAttempts(BiometricPosition bpos) {
        _SubCaptureField field = bpos == null || this.subFields.size() == 1 ? this.subFields.get(0) : this.getField(bpos);
        return field.getCaptureAttempts();
    }

    public CaptureAttempt getBestAttempt() {
        return this.getBestAttempt(null);
    }

    public CaptureAttempt getBestAttempt(BiometricPosition bpos) {
        _SubCaptureField field = bpos == null || this.subFields.size() == 1 ? this.subFields.get(0) : this.getField(bpos);
        return field.getBestAttempt();
    }

    public Map<BiometricPosition, CaptureAttempt> getAllBestAttempts() {
        HashMap<BiometricPosition, CaptureAttempt> result = new HashMap<BiometricPosition, CaptureAttempt>();
        for (_SubCaptureField field : this.subFields) {
            result.put(field.getBiometricPosition(), field.getBestAttempt());
        }
        return result;
    }

    public Map<BiometricPosition, List<CaptureAttempt>> getAllCaptureAttempts() {
        HashMap<BiometricPosition, List<CaptureAttempt>> result = new HashMap<BiometricPosition, List<CaptureAttempt>>();
        for (_SubCaptureField field : this.subFields) {
            result.put(field.getBiometricPosition(), field.getCaptureAttempts());
        }
        return result;
    }

    public CaptureAttempt getCurrentAttempt() {
        return this.subFields.get(0).getCurrentAttempt(this.capCounters);
    }

    public Map<BiometricPosition, CaptureAttempt> getAllCurrentAttempts() {
        HashMap<BiometricPosition, CaptureAttempt> result = new HashMap<BiometricPosition, CaptureAttempt>();
        for (_SubCaptureField field : this.subFields) {
            result.put(field.getBiometricPosition(), field.getCurrentAttempt(this.capCounters));
        }
        return result;
    }

    public boolean isQualityPassed() {
        if (!this.qssEnableFlag || this.capCounters.getMaxAttempts() > 0 && this.capCounters.getNumAttempts() >= this.capCounters.getMaxAttempts()) {
            return true;
        }
        return this.subFields.stream().noneMatch(field -> field.isEnabled() && !field.isQualityPassed());
    }

    public void stopCapture() {
        if (this.devCtxt == null) {
            return;
        }
        try {
            this.doEndCapture();
        }
        catch (Exception exep) {
            LOGGER.debug("error in external stop capture", (Throwable)exep);
        }
    }

    public void clear() {
        this.subFields.forEach(_SubCaptureField::clear);
        this.capCounters.reset();
        this.fingerMismatchCounter.reset();
        this.updateAttemptStatus();
        this.axnModel.updateActionButtons(this.capCounters);
    }

    public void delete(String attemptId) {
        int delIndex = -1;
        for (_SubCaptureField field : this.subFields) {
            List<CaptureAttempt> attempts = field.getCaptureAttempts();
            for (int i = 0; i < attempts.size(); ++i) {
                if (!StringUtils.equalsIgnoreCase((String)attempts.get(i).getId(), (String)attemptId)) continue;
                delIndex = i;
                break;
            }
            if (delIndex < 0) continue;
            break;
        }
        if (delIndex >= 0) {
            this.capCounters.setCurrentAttemptPos(delIndex);
            this.doDeleteCapture();
        }
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.axnModel != null) {
            this.axnModel.setEnabled(enabled);
        }
        if (enabled) {
            ArrayList missings = new ArrayList();
            if (this.bdp != null) {
                missings.addAll(this.bdp.getMissingFingers());
                missings.addAll(this.bdp.getMissingEyes());
            }
            if (this.subFields != null) {
                this.subFields.forEach(field -> {
                    if (missings.contains(field.getBiometricPosition())) {
                        field.setEnabled(false);
                        field.setBioException(true);
                    } else {
                        field.setEnabled(true);
                        field.setBioException(false);
                    }
                });
            }
        } else if (this.subFields != null) {
            this.subFields.forEach(field -> field.setEnabled(false));
        }
        if (!enabled) {
            this.clear();
        }
    }

    void doStartCapture() {
        List sfiList;
        if (this.axnModel.isCaptureInProgress()) {
            return;
        }
        this.resetMetaData();
        if (this.capCounters.getMaxAttempts() > 0 && this.capCounters.getNumAttempts() >= this.capCounters.getMaxAttempts()) {
            if (this.enrollmentService != null && this.enrollmentService.isUniversalClientTrnx()) {
                this.displayMessageUC(LabelAndMsgKeys.MSG_MAXCAP.toString());
            } else {
                this.displayMessage(LabelAndMsgKeys.MSG_MAXCAP.toString());
            }
            return;
        }
        IClientDeviceManager cdm = this.getClientDeviceManager();
        if (cdm == null || this.player == null) {
            return;
        }
        if (this.devCtxt != null) {
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
            this.devCtxt = null;
        }
        this.devCtxt = cdm.getDeviceContext(this.devType);
        if (this.devCtxt == null) {
            switch (this.devType) {
                case FINGERPRINT: {
                    if (this.enrollmentService.isOnlineUpdate()) {
                        this.displayMessageUC(LabelAndMsgKeys.MSG_NODEV_FINGER.toString());
                        break;
                    }
                    this.displayMessage(LabelAndMsgKeys.MSG_NODEV_FINGER.toString());
                    break;
                }
                case PHOTO: {
                    if (this.enrollmentService.isOnlineUpdate()) {
                        this.displayMessageUC(LabelAndMsgKeys.MSG_NODEV_CAMERA.toString());
                        break;
                    }
                    this.displayMessage(LabelAndMsgKeys.MSG_NODEV_CAMERA.toString());
                    break;
                }
                case IRIS: {
                    if (this.enrollmentService.isOnlineUpdate()) {
                        this.displayMessageUC(LabelAndMsgKeys.MSG_NODEV_IRIS.toString());
                        break;
                    }
                    this.displayMessage(LabelAndMsgKeys.MSG_NODEV_IRIS.toString());
                }
            }
            return;
        }
        this.devCtxt.addImageListener((INonRDImageListener)this.imgHandler);
        this.player.startPreview((IGenericDeviceContext)this.devCtxt);
        CaptureRequest request = new CaptureRequest();
        request.setBiometricPosition(this.bioPos);
        switch (this.bioPos) {
            case LEFT_SLAP: {
                request.getMissingBiometrics().addAll(BioxDataAnalyzer.getLeftSlapExceptions((IBioxDataProvider)this.bdp));
                break;
            }
            case RIGHT_SLAP: {
                request.getMissingBiometrics().addAll(BioxDataAnalyzer.getRightSlapExceptions((IBioxDataProvider)this.bdp));
                break;
            }
            case BOTH_THUMBS: {
                request.getMissingBiometrics().addAll(BioxDataAnalyzer.getThumbSlapExceptions((IBioxDataProvider)this.bdp));
                break;
            }
            case BOTH_IRIS: {
                List expos = this.bdp.getMissingEyes();
                if (expos == null) break;
                request.getMissingBiometrics().addAll(expos);
            }
        }
        List vfiList = this.devCtxt.getDeviceInformation().getVideoFormats();
        if (vfiList != null && vfiList.size() > 0) {
            request.setVideoFormatId(((VideoFormatInfo)vfiList.get(0)).getVideoFormatId());
        }
        if ((sfiList = this.devCtxt.getDeviceInformation().getSampleFormats()) != null && sfiList.size() > 0) {
            request.setSampleFormatId(((SampleFormatInfo)sfiList.get(0)).getFormatId());
        }
        request.setManualCapture(true);
        this.leftFlipLayout.show(this.leftControlBar, NAME_END_FORCE_PANEL);
        if (!this.devCtxt.startCapture(request)) {
            this.leftFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
            this.player.setVisible(false);
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.player.setVisible(true);
        this.axnModel.setCaptureInProgress(true);
        this.subFields.forEach(field -> field.setThumbToolTip(TIP_AFTER_START));
        this.fireCaptureStarted();
    }

    private _SubCaptureField getField(BiometricPosition bpos) {
        if (this.subFields.isEmpty()) {
            return null;
        }
        if (this.subFields.size() == 1) {
            return this.subFields.get(0);
        }
        return this.subFields.stream().filter(field -> field.getBiometricPosition().equals((Object)bpos)).findFirst().orElse(null);
    }

    private void resetMetaData() {
        this.startTime = Long.MIN_VALUE;
        this.endTime = Long.MIN_VALUE;
        this.forcedCapture = false;
        this.axnModel.setCaptureInProgress(false);
    }

    void setCaptureGroup(BiometricsCaptureGroup group) {
        this.bioGroup = group;
    }

    void clearCaptureGroup() {
        this.bioGroup = null;
    }

    _CaptureActionModel getActionModel() {
        return this.axnModel;
    }

    void doEndCapture() {
        this.resetMetaData();
        if (this.devCtxt != null) {
            this.devCtxt.removeImageListener((INonRDImageListener)this.imgHandler);
            if (!this.devCtxt.endCapture()) {
                LOGGER.debug("failed to end capture");
            }
        }
        if (this.player != null) {
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
            this.player.setVisible(false);
        }
        this.devCtxt = null;
        this.leftFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
        this.subFields.forEach(field -> field.setThumbToolTip(TIP_NO_START));
        this.fireCaptureStopped();
    }

    void doForceCapture() {
        long now = System.currentTimeMillis();
        if (this.startTime > 0L && now - this.startTime < this.forceCaptureMinDelay) {
            return;
        }
        this.forcedCapture = true;
        if (this.player != null) {
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
            this.player.setVisible(false);
        }
        if (this.devCtxt == null) {
            return;
        }
        boolean success = this.devCtxt.forceCapture();
        this.devCtxt = null;
        this.leftFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
        if (success) {
            LOGGER.debug("force capture requested");
            this.subFields.forEach(field -> field.setThumbToolTip(TIP_NO_START));
            this.fireCaptureForced();
        } else {
            LOGGER.debug("failed to force capture");
            this.setWait(false);
            this.forcedCapture = false;
        }
    }

    void doPreviousCapture() {
        this.capCounters.previousAttempt();
        this.subFields.forEach(field -> field.updateCurrentCapture(this.capCounters));
        this.capCounters.stat();
        this.axnModel.updateActionButtons(this.capCounters);
    }

    void doNextCapture() {
        this.capCounters.nextAttempt();
        this.subFields.forEach(field -> field.updateCurrentCapture(this.capCounters));
        this.capCounters.stat();
        this.axnModel.updateActionButtons(this.capCounters);
    }

    public void doDeleteCapture() {
        ArrayList<String> deletedIds = new ArrayList<String>();
        for (_SubCaptureField field2 : this.subFields) {
            String attemptId = field2.deleteCapture(this.capCounters);
            if (attemptId == null) continue;
            deletedIds.add(attemptId);
        }
        if (this.enrollmentService != null && this.enrollmentService.isUniversalClientTrnx()) {
            this.capCounters.deleteAttemptUC();
        } else {
            this.capCounters.deleteAttempt();
        }
        this.subFields.forEach(field -> field.updateCurrentCapture(this.capCounters));
        this.capCounters.stat();
        this.axnModel.updateActionButtons(this.capCounters);
        this.updateAttemptStatus();
        this.isDelete = true;
        this.fireSampleDeleted(deletedIds.toArray(new String[deletedIds.size()]));
    }

    private String[] doImageReceived(CapturedImage[] cimage) {
        if (this.player != null) {
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
            this.player.setVisible(false);
        }
        this.leftFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
        this.endTime = System.currentTimeMillis();
        LOGGER.debug("captured image received");
        if (this.capCounters.getMaxAttempts() > 0 && this.capCounters.getNumAttempts() >= this.capCounters.getMaxAttempts()) {
            LOGGER.debug("maximum attempts reached");
            return null;
        }
        if (cimage == null || cimage.length == 0) {
            LOGGER.warn("no captured image");
            return null;
        }
        int enabledCount = (int)this.subFields.stream().filter(Component::isEnabled).count();
        if (enabledCount != cimage.length) {
            LOGGER.warn("captured image to sub-field count mismatch");
            return null;
        }
        List missingFingers = null;
        List missingEyes = null;
        if (this.bdp != null) {
            missingFingers = this.bdp.getMissingFingers();
            missingEyes = this.bdp.getMissingEyes();
        }
        HashMap<_SubCaptureField, CaptureAttempt> faMap = new HashMap<_SubCaptureField, CaptureAttempt>();
        ArrayList<String> attemptIdList = new ArrayList<String>();
        int attIdx = 0;
        for (_SubCaptureField field2 : this.subFields) {
            CaptureAttempt attempt;
            if (missingFingers != null && missingFingers.contains(field2.getBiometricPosition())) {
                faMap.put(field2, null);
                continue;
            }
            if (missingEyes != null && missingEyes.contains(field2.getBiometricPosition())) {
                faMap.put(field2, null);
                continue;
            }
            if ((attempt = this.createAttempt(cimage[attIdx++], field2.getBiometricPosition())) != null) {
                faMap.put(field2, attempt);
                attemptIdList.add(attempt.getId());
            }
            if (attIdx < cimage.length) continue;
            break;
        }
        if (!faMap.isEmpty()) {
            this.capCounters.addAttempt();
            faMap.keySet().forEach(field -> field.addCaptureAttempt((CaptureAttempt)faMap.get(field), this.capCounters));
        }
        this.subFields.stream().filter(Component::isEnabled).forEach(field -> field.updateCurrentCapture(this.capCounters));
        return attemptIdList.toArray(new String[attemptIdList.size()]);
    }

    private void updateAttemptStatus() {
        int maxAttempts = this.capCounters.getMaxAttempts();
        int numAttempts = this.capCounters.getNumAttempts();
        if (maxAttempts <= 0) {
            return;
        }
        int left = maxAttempts - numAttempts;
        if (this.ldeco != null) {
            this.ldeco.localize(this.attemptLabel, (Object)LabelAndMsgKeys.LABEL_ATTEMPTS, left);
        } else {
            this.attemptLabel.setText(left + " remaining");
        }
    }

    private void setWait(boolean flag) {
        LOGGER.debug("set to wait: " + flag);
        this.axnModel.setEnabled(!flag);
        this.subFields.forEach(field -> field.setWait(flag));
    }

    private CaptureAttempt createAttempt(CapturedImage cimage, BiometricPosition bpos) {
        if (cimage == null) {
            LOGGER.warn("no captured image");
            return null;
        }
        byte[] data = cimage.getImageData();
        if (ArrayUtils.isEmpty((byte[])data)) {
            LOGGER.warn("no data in captured image");
            return null;
        }
        if (bpos == null) {
            bpos = this.bioPos;
        }
        CaptureAttempt attempt = new CaptureAttempt();
        IDeviceContext dc = this.getClientDeviceManager().getDeviceContext(this.devType);
        DeviceInfo devInfo = null;
        if (dc != null) {
            devInfo = dc.getDeviceInformation();
        }
        attempt.setDeviceInfo(devInfo);
        attempt.setStartTime(this.startTime);
        attempt.setEndTime(this.endTime);
        attempt.setForcedCapture(this.forcedCapture);
        attempt.setFtcFlag(this.ftcFlag);
        if (!this.qssEnableFlag) {
            attempt.setImage(cimage);
            attempt.setPass(true);
            return attempt;
        }
        CaptureProcessorFactory cpf = new CaptureProcessorFactory(this.devType, this.bdp);
        cpf.setFingerMismatchCounter(this.fingerMismatchCounter);
        IQSSProcessor qproc = cpf.createQSSProcessor(cimage, bpos);
        if (!qproc.process()) {
            AudioPlayer.getInstance().play("res/cui/sounds/cap-failure.wav");
            this.displayMessage(LabelAndMsgKeys.MSG_QSS_ERROR.toString());
            return null;
        }
        AudioPlayer.getInstance().play(qproc.isPass() ? "res/cui/sounds/cap-success.wav" : "res/cui/sounds/cap-failure.wav");
        List acceptList = qproc.getAcceptance();
        if (acceptList != null && !acceptList.isEmpty()) {
            String[] warnList = new String[acceptList.size()];
            int count = 0;
            for (Acceptance accept : acceptList) {
                if (accept.getLevel().equals((Object)Acceptance.Level.ERROR)) {
                    if (this.enrollmentService.isUniversalClientTrnx()) {
                        this.displayMessageUC(accept.getMessage());
                    } else {
                        this.displayMessage(accept.getMessage());
                    }
                    return null;
                }
                if (accept.getLevel().equals((Object)Acceptance.Level.WARN)) {
                    warnList[count++] = accept.getMessage();
                }
                if (!accept.getLevel().equals((Object)Acceptance.Level.FAIL)) continue;
                if (!this.showFailAccept(accept.getMessage())) {
                    return null;
                }
                this.ftcFlag = true;
            }
            if (count > 0 && !this.showRejectAccept(warnList)) {
                return null;
            }
        }
        attempt.setImage(qproc.getCapturedImage());
        attempt.setScore((double)qproc.getCapturedImage().getQuality());
        attempt.setPass(qproc.isPass());
        attempt.setQSS(qproc.getQSSData());
        attempt.setAttemptNumber(this.capCounters.getNumAttempts());
        if (qproc.getTemplates() != null) {
            attempt.getTemplates().addAll(qproc.getTemplates());
        }
        return attempt;
    }

    private boolean showFailAccept(String message) {
        return L10nOptionPaneBuilder.getInstance().showYesNoConfirmation(message, this).equals((Object)MsgKeysCommon.YES);
    }

    private boolean showRejectAccept(String[] messages) {
        int i;
        JLabel[] labels = new JLabel[messages.length + 1];
        for (i = 0; i < messages.length; ++i) {
            labels[i] = new JLabel();
            this.ldeco.localize(labels[i], (Object)messages[i], new Object[0]);
        }
        labels[i] = new JLabel();
        this.ldeco.localize(labels[i], (Object)"bio-stat:msg.warn.footer", new Object[0]);
        return L10nOptionPaneBuilder.getInstance().showYesNoConfirmation(labels, SwingUtilities.getWindowAncestor(this)).equals((Object)MsgKeysCommon.YES);
    }

    private void displayMessage(String rbKey) {
        L10nOptionPaneBuilder.getInstance().showError(rbKey, this, new Object[0]);
    }

    private void displayMessageUC(String rbKey) {
        L10nOptionPaneBuilder.getInstance().showError(rbKey, this, new Object[0]);
    }

    private void displayMessageUC(String code, String msg) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(msg, this, code, this.enrollmentService.getTransactionId(), new Object[0]);
    }

    private class SubCaptureContext
    implements ISubCaptureContext {
        private SubCaptureContext() {
        }

        @Override
        public void doQSSActionPerformed(ActionEvent evt, BiometricPosition bpos) {
            _SubCaptureField field = BiometricsCaptureField.this.getField(bpos);
            if (field != null) {
                field.handleQSSAction(evt);
            }
        }

        @Override
        public void doThumbClicked() {
            if (BiometricsCaptureField.this.bioGroup != null) {
                BiometricsCaptureField.this.bioGroup.startStopCapture(BiometricsCaptureField.this);
            } else if (!BiometricsCaptureField.this.axnModel.isCaptureInProgress()) {
                BiometricsCaptureField.this.axnModel.getStartButton().doClick();
            } else {
                BiometricsCaptureField.this.axnModel.getEndButton().doClick();
            }
        }
    }

    private class AccessibleBiometricCapture
    extends JComponent.AccessibleJComponent {
        private AccessibleBiometricCapture() {
            super(BiometricsCaptureField.this);
        }
    }

    private class FieldComponentHandler
    extends ComponentAdapter {
        private FieldComponentHandler() {
        }

        @Override
        public void componentHidden(ComponentEvent evt) {
            this.doMinMax();
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
            this.doMinMax();
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            this.doMinMax();
        }

        @Override
        public void componentShown(ComponentEvent evt) {
            this.doMinMax();
        }

        private void doMinMax() {
            Boolean minimized = (Boolean)BiometricsCaptureField.this.getClientProperty("minimized");
            if (minimized == null) {
                return;
            }
            BiometricsCaptureField.this.leftControlBar.setVisible(minimized == false);
            BiometricsCaptureField.this.rightControlBar.setVisible(minimized == false);
            BiometricsCaptureField.this.subFields.forEach(field -> field.setPreviewMode(minimized));
            BiometricsCaptureField.this.fieldArea.setLayout(minimized != false ? BiometricsCaptureField.this.minLayout : BiometricsCaptureField.this.maxLayout);
            BiometricsCaptureField.this.validate();
            BiometricsCaptureField.this.repaint();
        }
    }

    private class DeviceImageHandler
    implements INonRDImageListener {
        private DeviceImageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void imageReceived(CapturedImage[] cimage) {
            String[] attemptIds;
            BiometricsCaptureField.this.axnModel.setCaptureInProgress(false);
            BiometricsCaptureField.this.subFields.forEach(field -> field.setThumbToolTip(BiometricsCaptureField.TIP_NO_START));
            try {
                BiometricsCaptureField.this.setWait(true);
                BiometricsCaptureField.this.fireComponentBusy();
                attemptIds = BiometricsCaptureField.this.doImageReceived(cimage);
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                BiometricsCaptureField.this.fireComponentReady();
                BiometricsCaptureField.this.setWait(false);
                BiometricsCaptureField.this.capCounters.stat();
                BiometricsCaptureField.this.axnModel.updateActionButtons(BiometricsCaptureField.this.capCounters);
                BiometricsCaptureField.this.updateAttemptStatus();
                if (BiometricsCaptureField.this.devCtxt != null) {
                    BiometricsCaptureField.this.devCtxt.removeImageListener((INonRDImageListener)BiometricsCaptureField.this.imgHandler);
                }
                BiometricsCaptureField.this.devCtxt = null;
            }
            BiometricsCaptureField.this.fireSampleReceived(attemptIds);
        }
    }
}

