/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.capture;

import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.bio.BioButtonUtils;
import in.gov.uidai.swing.bio.BiometricsIcons;
import in.gov.uidai.swing.bio.LabelAndMsgKeys;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import in.gov.uidai.swing.bio.capture._CaptureCounters;
import in.gov.uidai.swing.event.AsyncAction;
import in.gov.uidai.swing.event.ReferentMouseAdapter;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class _CaptureActionModel {
    private final BiometricsCaptureField capField;
    private final JButton startBut;
    private final JButton endBut;
    private final JButton forceBut;
    private final JButton prevBut;
    private final JButton nextBut;
    private final JButton deleteBut;
    private MouseListener playerMouse;
    private boolean captureInProgress;

    _CaptureActionModel(BiometricsCaptureField cap) {
        this.capField = cap;
        new BiometricsIcons();
        ActionListener startl = evt -> this.capField.doStartCapture();
        AsyncAction startAxn = new AsyncAction().setName("Start Capture").setCommandKey("StartCapture").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_CAP_START_ICON")).setHandler(startl);
        ActionListener endl = evt -> this.capField.doEndCapture();
        AsyncAction stopAxn = new AsyncAction().setName("Stop Capture").setCommandKey("StopCapture").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_CAP_STOP_ICON")).setHandler(endl);
        ActionListener forcel = evt -> this.capField.doForceCapture();
        AsyncAction forceAxn = new AsyncAction().setName("Force Capture").setCommandKey("ForceCapture").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_CAP_FORCE_ICON")).setHandler(forcel);
        ActionListener prevl = evt -> this.capField.doPreviousCapture();
        AsyncAction previousAxn = new AsyncAction().setName("Previous Attempt").setCommandKey("PreviousAttempt").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_PREVIOUS_ICON")).setHandler(prevl);
        ActionListener nextl = evt -> this.capField.doNextCapture();
        AsyncAction nextAxn = new AsyncAction().setName("Next Attempt").setCommandKey("NextAttempt").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_NEXT_ICON")).setHandler(nextl);
        ActionListener dell = evt -> {
            MsgKeysCommon confirmation = L10nOptionPaneBuilder.getInstance().showYesNoConfirmation((Object)LabelAndMsgKeys.MSG_DELETE, SwingUtilities.getRoot((Component)evt.getSource()));
            if (confirmation.equals((Object)MsgKeysCommon.YES)) {
                this.capField.doDeleteCapture();
            }
        };
        AsyncAction delAxn = new AsyncAction().setName("Delete Capture").setCommandKey("Delete").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_DEL_ICON")).setHandler(dell);
        InputMap ipMap = this.capField.getInputMap(1);
        ActionMap axnMap = this.capField.getActionMap();
        ipMap.put(KeyStroke.getKeyStroke("SPACE"), "start");
        axnMap.put("start", startAxn);
        ipMap.put(KeyStroke.getKeyStroke("ENTER"), "force");
        axnMap.put("force", forceAxn);
        ipMap.put(KeyStroke.getKeyStroke("ESCAPE"), "stop");
        axnMap.put("stop", stopAxn);
        ipMap.put(KeyStroke.getKeyStroke("DELETE"), "delete");
        axnMap.put("delete", delAxn);
        ipMap.put(KeyStroke.getKeyStroke("LEFT"), "previous");
        axnMap.put("previous", previousAxn);
        ipMap.put(KeyStroke.getKeyStroke("RIGHT"), "next");
        axnMap.put("next", nextAxn);
        this.startBut = BioButtonUtils.createControlButton(startAxn);
        this.endBut = BioButtonUtils.createControlButton(stopAxn);
        this.forceBut = BioButtonUtils.createControlButton(forceAxn);
        this.prevBut = BioButtonUtils.createControlButton(previousAxn);
        this.prevBut.setVisible(false);
        this.nextBut = BioButtonUtils.createControlButton(nextAxn);
        this.nextBut.setVisible(false);
        this.deleteBut = BioButtonUtils.createControlButton(delAxn);
        this.deleteBut.setVisible(false);
    }

    public void localize(L10nDecorator deco) {
        deco.localizeToolTip(this.startBut, "bio-stat:tt.capture.start", new Object[0]);
        deco.localizeToolTip(this.endBut, "bio-stat:tt.capture.stop", new Object[0]);
        deco.localizeToolTip(this.deleteBut, "bio-stat:tt.capture.delete", new Object[0]);
        deco.localizeToolTip(this.prevBut, "bio-stat:tt.capture.previous", new Object[0]);
        deco.localizeToolTip(this.nextBut, "bio-stat:tt.capture.next", new Object[0]);
    }

    public JButton getStartButton() {
        return this.startBut;
    }

    public JButton getEndButton() {
        return this.endBut;
    }

    public JButton getForceButton() {
        return this.forceBut;
    }

    public JButton getPreviousButton() {
        return this.prevBut;
    }

    public JButton getNextButton() {
        return this.nextBut;
    }

    public JButton getDeleteButton() {
        return this.deleteBut;
    }

    public boolean isCaptureInProgress() {
        return this.captureInProgress;
    }

    public void setCaptureInProgress(boolean flag) {
        this.captureInProgress = flag;
    }

    public void applyForceMouseListener(JComponent comp) {
        this.playerMouse = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() != 1) {
                    return;
                }
                if (evt.isControlDown() || evt.isShiftDown() || evt.isAltDown()) {
                    return;
                }
                if (evt.isAltGraphDown() || evt.isMetaDown()) {
                    return;
                }
                if (_CaptureActionModel.this.captureInProgress) {
                    _CaptureActionModel.this.forceBut.doClick();
                }
            }
        };
        ReferentMouseAdapter refAdapter = new ReferentMouseAdapter();
        refAdapter.setMouseListener(this.playerMouse);
        comp.addMouseListener(refAdapter);
    }

    public void setEnabled(boolean flag) {
        this.startBut.setEnabled(flag);
        this.prevBut.setEnabled(flag);
        this.nextBut.setEnabled(flag);
        this.deleteBut.setEnabled(flag);
    }

    public void updateActionButtons(_CaptureCounters capCounters) {
        int numAttempts = capCounters.getNumAttempts();
        int pos = capCounters.getCurrentAttemptPos();
        if (numAttempts <= 0) {
            this.prevBut.setVisible(false);
            this.nextBut.setVisible(false);
        } else {
            this.prevBut.setVisible(true);
            this.nextBut.setVisible(true);
            if (pos <= 0) {
                this.prevBut.setVisible(false);
            }
            if (pos >= numAttempts - 1) {
                this.nextBut.setVisible(false);
            }
        }
        this.deleteBut.setVisible(pos >= 0 && pos < numAttempts);
    }
}

