/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.capture;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _CaptureCounters {
    private static final Logger LOGGER = LoggerFactory.getLogger(_CaptureCounters.class);
    private int maxAttempts;
    private int currAttemptPos;
    private int numAttempts;

    _CaptureCounters() {
    }

    public void reset() {
        this.currAttemptPos = 0;
        this.numAttempts = 0;
    }

    void setMaxAttempts(int value) {
        this.maxAttempts = value;
    }

    int getMaxAttempts() {
        return this.maxAttempts;
    }

    int getCurrentAttemptPos() {
        return this.currAttemptPos;
    }

    void setCurrentAttemptPos(int pos) {
        if (this.numAttempts <= 0) {
            this.currAttemptPos = -1;
            return;
        }
        this.currAttemptPos = pos;
        if (this.currAttemptPos < 0) {
            this.currAttemptPos = 0;
        }
        if (this.currAttemptPos >= this.numAttempts) {
            this.currAttemptPos = this.numAttempts - 1;
        }
    }

    int getNumAttempts() {
        return this.numAttempts;
    }

    void previousAttempt() {
        if (this.numAttempts <= 0) {
            this.currAttemptPos = -1;
            return;
        }
        --this.currAttemptPos;
        if (this.currAttemptPos < 0) {
            this.currAttemptPos = 0;
        }
    }

    void nextAttempt() {
        if (this.numAttempts <= 0) {
            this.currAttemptPos = -1;
            return;
        }
        ++this.currAttemptPos;
        if (this.currAttemptPos >= this.numAttempts) {
            this.currAttemptPos = this.numAttempts - 1;
        }
    }

    void addAttempt() {
        if (this.maxAttempts > 0) {
            ++this.numAttempts;
            if (this.numAttempts >= this.maxAttempts) {
                this.numAttempts = this.maxAttempts;
            }
            this.currAttemptPos = this.numAttempts - 1;
        } else {
            this.numAttempts = 1;
            this.currAttemptPos = 0;
        }
    }

    void deleteAttempt() {
        --this.numAttempts;
        if (this.numAttempts < 0) {
            this.numAttempts = 0;
        }
        if (this.currAttemptPos >= this.numAttempts) {
            this.currAttemptPos = this.numAttempts - 1;
        }
    }

    void deleteAttemptUC() {
        --this.numAttempts;
        if (this.numAttempts < 0) {
            this.numAttempts = 0;
        }
        if (this.currAttemptPos >= this.numAttempts && this.numAttempts > 0) {
            this.currAttemptPos = this.numAttempts - 1;
        }
    }

    public void stat() {
        LOGGER.debug("max: " + this.maxAttempts + ", total: " + this.numAttempts + ", current: " + this.currAttemptPos);
    }
}

