/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.capture;

import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.BioButtonUtils;
import in.gov.uidai.swing.bio.BiometricsIcons;
import in.gov.uidai.swing.bio.capture.ISubCaptureContext;
import in.gov.uidai.swing.event.AsyncAction;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;

class _CaptureStatusBar
extends TransparentBox {
    private final JProgressBar scoreBar;
    private final JLabel scoreLabel;
    private final JLabel bestIndicator;
    private final JButton qssBut;
    private AsyncAction qssAxn;

    _CaptureStatusBar(final ISubCaptureContext capCtxt, final BiometricPosition bpos) {
        new BiometricsIcons();
        double[][] guides = new double[][]{{30.0, 2.0, -1.0, 2.0, 25.0, 2.0, 25.0}, {0.0, 25.0, 0.0}};
        this.setLayout(new TableLayout(guides));
        this.scoreLabel = new JLabel("Score");
        this.add((Component)this.scoreLabel, "0, 1, full, center");
        this.scoreBar = new JProgressBar(0, 100);
        this.scoreBar.setStringPainted(true);
        this.bestIndicator = new JLabel(ImageIconCache.getInst().getIcon("KEY_CAP_BEST_ICON"));
        this.bestIndicator.setToolTipText("This is the best capture");
        this.bestIndicator.setVisible(false);
        ActionListener qssl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                capCtxt.doQSSActionPerformed(evt, bpos);
            }
        };
        this.qssAxn = new AsyncAction().setName("QSS Details").setCommandKey("QSSDetails").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_QSS_ICON")).setHandler(qssl);
        this.qssBut = BioButtonUtils.createControlButton(this.qssAxn);
        this.qssBut.setVisible(false);
        this.add((Component)this.scoreBar, "2, 1, full, full");
        this.add((Component)this.bestIndicator, "4, 1, full, full");
        this.add((Component)this.qssBut, "6, 1, full, full");
    }

    public void addQssKeyBinding(JComponent field) {
        InputMap ipMap = field.getInputMap(1);
        ActionMap axnMap = field.getActionMap();
        ipMap.put(KeyStroke.getKeyStroke("control Q"), "qss");
        axnMap.put("qss", this.qssAxn);
    }

    void localize(L10nDecorator deco) {
        deco.localize(this.scoreLabel, (Object)"bio-stat:label.score", new Object[0]);
        deco.localizeToolTip(this.qssBut, "bio-stat:tt.qss", new Object[0]);
        deco.localizeToolTip(this.bestIndicator, "bio-stat:tt.capture.best", new Object[0]);
    }

    void setBest(boolean flag) {
        this.bestIndicator.setVisible(flag);
    }

    void setPass(boolean flag) {
        if (flag) {
            this.scoreBar.putClientProperty("status", "pass");
        } else {
            this.scoreBar.putClientProperty("status", "fail");
        }
    }

    void clearPass() {
        this.scoreBar.putClientProperty("status", null);
    }

    void setScore(int score) {
        this.scoreBar.setValue(score);
    }

    void setQSSVisible(boolean flag) {
        this.qssBut.setVisible(flag);
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.qssBut != null) {
            this.qssBut.setEnabled(enabled);
        }
    }
}

