/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.capture;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.capture.ISubCaptureContext;
import in.gov.uidai.swing.bio.capture._CaptureCounters;
import in.gov.uidai.swing.bio.capture._CaptureStatusBar;
import in.gov.uidai.swing.bio.thumb.CaptureThumbnail;
import in.gov.uidai.swing.bio.thumb.ThumbOverlay;
import in.gov.uidai.swing.border.DashedBorder;
import in.gov.uidai.swing.event.ReferentMouseAdapter;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.JComponent;

class _SubCaptureField
extends TransparentBox {
    private final BiometricPosition bioPos;
    private final List<CaptureAttempt> attemptList;
    private final List<CaptureAttempt> deletedList;
    private final CaptureThumbnail thumbnail;
    private final _CaptureStatusBar statusBar;
    private final ThumbOverlay waitOvl;
    private final List<ActionListener> axnList;
    private final MouseListener thumbMouse;
    private final ISubCaptureContext capCtxt;
    private final List<BiConsumer<BiometricPosition, CaptureAttempt>> bestCaptureAttemptChangeListeners = new ArrayList<BiConsumer<BiometricPosition, CaptureAttempt>>();
    private final List<BiConsumer<BiometricPosition, CaptureAttempt>> captureAttemptAdditionChangeListeners = new ArrayList<BiConsumer<BiometricPosition, CaptureAttempt>>();
    private final List<BiConsumer<BiometricPosition, CaptureAttempt>> captureAttemptDeletionChangeListeners = new ArrayList<BiConsumer<BiometricPosition, CaptureAttempt>>();
    private final List<Consumer<BiometricPosition>> captureAttemptClearChangeListeners = new ArrayList<Consumer<BiometricPosition>>();
    private CaptureAttempt bestAttempt;
    private boolean qssEnableFlag;
    private boolean bioException;

    _SubCaptureField(ISubCaptureContext ctxt, BiometricPosition bpos) {
        this.attemptList = new ArrayList<CaptureAttempt>();
        this.deletedList = new ArrayList<CaptureAttempt>();
        this.capCtxt = ctxt;
        this.bioPos = bpos;
        this.thumbnail = new CaptureThumbnail();
        this.thumbnail.setBackground(Color.decode("#000000"));
        this.thumbnail.setOpaque(true);
        this.thumbnail.setBorder(new DashedBorder().dashInterval("1, 2").lineColor(Color.decode("#666666")).lineThickness(1.0f));
        this.thumbnail.setCursor(Cursor.getPredefinedCursor(12));
        this.thumbnail.setFocusable(false);
        this.statusBar = new _CaptureStatusBar(this.capCtxt, bpos);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.thumbnail, "Center");
        this.add((Component)this.statusBar, "South");
        this.waitOvl = new ThumbOverlay("WaitIndicator").image("KEY_CAP_WAIT_ICON").origin(0).offset(0, 0).visible(false);
        this.thumbnail.addOverlay(this.waitOvl);
        this.thumbMouse = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (_SubCaptureField.this.bioException) {
                    return;
                }
                if (evt.getButton() != 1) {
                    return;
                }
                if (evt.isControlDown() || evt.isShiftDown() || evt.isAltDown()) {
                    return;
                }
                if (evt.isAltGraphDown() || evt.isMetaDown()) {
                    return;
                }
                _SubCaptureField.this.capCtxt.doThumbClicked();
            }
        };
        ReferentMouseAdapter refAdapter = new ReferentMouseAdapter();
        refAdapter.setMouseListener(this.thumbMouse);
        this.thumbnail.addMouseListener(refAdapter);
        this.axnList = new ArrayList<ActionListener>();
    }

    void addBestCaptureAttemptChangeListeners(BiConsumer<BiometricPosition, CaptureAttempt> delegate) {
        this.bestCaptureAttemptChangeListeners.add(delegate);
    }

    void addCaptureAttemptAdditionChangeListeners(BiConsumer<BiometricPosition, CaptureAttempt> delegate) {
        this.captureAttemptAdditionChangeListeners.add(delegate);
    }

    void addCaptureAttemptDeletionChangeListeners(BiConsumer<BiometricPosition, CaptureAttempt> delegate) {
        this.captureAttemptDeletionChangeListeners.add(delegate);
    }

    void addCaptureAttemptClearChangeListeners(Consumer<BiometricPosition> delegate) {
        this.captureAttemptClearChangeListeners.add(delegate);
    }

    private void fireCaptureAttemptAdditionChange(CaptureAttempt attempt) {
        this.captureAttemptAdditionChangeListeners.forEach(listener -> listener.accept(this.bioPos, attempt));
    }

    private void fireCaptureAttemptDeletionChange(CaptureAttempt attempt) {
        this.captureAttemptDeletionChangeListeners.forEach(listener -> listener.accept(this.bioPos, attempt));
    }

    private void fireCaptureAttemptClear() {
        this.captureAttemptClearChangeListeners.forEach(listener -> listener.accept(this.bioPos));
    }

    private void fireBestCaptureAttemptChange() {
        this.bestCaptureAttemptChangeListeners.forEach(listener -> listener.accept(this.bioPos, this.bestAttempt));
    }

    public void localize(L10nDecorator deco) {
        this.statusBar.localize(deco);
    }

    void setQSSEnabled(boolean flag) {
        this.statusBar.setVisible(flag);
        this.qssEnableFlag = flag;
    }

    void setThumbToolTip(String text) {
        this.thumbnail.setToolTipText(text);
    }

    public void addQSSActionListener(ActionListener l) {
        this.axnList.add(l);
    }

    void addQssKeyBinding(JComponent field) {
        this.statusBar.addQssKeyBinding(field);
    }

    void removeQSSActionListener(ActionListener l) {
        this.axnList.remove(l);
    }

    BiometricPosition getBiometricPosition() {
        return this.bioPos;
    }

    void setBioException(boolean missingFlag) {
        this.bioException = missingFlag;
    }

    void addCaptureAttempt(CaptureAttempt attempt, _CaptureCounters counters) {
        if (counters.getMaxAttempts() <= 0) {
            this.attemptList.clear();
        }
        this.attemptList.add(attempt);
        this.fireCaptureAttemptAdditionChange(attempt);
        this.calculateBestAttempt();
    }

    List<CaptureAttempt> getCaptureAttempts() {
        ArrayList<CaptureAttempt> result = new ArrayList<CaptureAttempt>();
        result.addAll(this.attemptList);
        result.addAll(this.deletedList);
        return result;
    }

    CaptureAttempt getBestAttempt() {
        if (this.bestAttempt != null) {
            return this.bestAttempt;
        }
        return null;
    }

    CaptureAttempt getCurrentAttempt(_CaptureCounters counters) {
        int pos = counters.getCurrentAttemptPos();
        if (pos < 0 || pos >= this.attemptList.size()) {
            return null;
        }
        return this.attemptList.get(pos);
    }

    boolean isQualityPassed() {
        return this.attemptList.stream().anyMatch(attempt -> attempt != null && attempt.isPass());
    }

    void updateCurrentCapture(_CaptureCounters counters) {
        int pos = this.attemptList.isEmpty() ? -1 : counters.getCurrentAttemptPos();
        this.doShowThumbNail(pos);
        this.updateIndicators(counters);
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.thumbnail.setEnabled(enabled);
        this.statusBar.setEnabled(enabled);
        if (!enabled) {
            this.thumbnail.setToolTipText(null);
        }
    }

    String deleteCapture(_CaptureCounters counters) {
        if (this.attemptList.isEmpty()) {
            return null;
        }
        CaptureAttempt attempt = this.attemptList.remove(counters.getCurrentAttemptPos());
        if (attempt == null) {
            return null;
        }
        attempt.delete();
        this.deletedList.add(attempt);
        this.fireCaptureAttemptDeletionChange(attempt);
        this.calculateBestAttempt();
        return attempt.getId();
    }

    void handleQSSAction(ActionEvent evt) {
        this.axnList.forEach(l -> l.actionPerformed(evt));
    }

    public void setWait(boolean flag) {
        boolean waitVisibleFlag = flag && !this.bioException;
        boolean thumbEnableFalg = !this.bioException && !flag;
        this.waitOvl.visible(waitVisibleFlag);
        this.thumbnail.setEnabled(thumbEnableFalg);
    }

    void setPreviewMode(boolean flag) {
        if (flag) {
            this.statusBar.setVisible(false);
        } else if (this.qssEnableFlag) {
            this.statusBar.setVisible(true);
        }
    }

    public void clear() {
        this.attemptList.clear();
        this.deletedList.clear();
        this.bestAttempt = null;
        this.thumbnail.setThumbnailImage(null);
        this.statusBar.setBest(false);
        this.statusBar.setScore(0);
        this.statusBar.setQSSVisible(false);
        this.statusBar.clearPass();
        this.fireCaptureAttemptClear();
    }

    private void doShowThumbNail(int pos) {
        if (pos < 0 || pos >= this.attemptList.size()) {
            this.thumbnail.setThumbnailImage(null);
            this.statusBar.setScore(0);
            return;
        }
        CaptureAttempt attempt = this.attemptList.get(pos);
        if (attempt == null) {
            return;
        }
        CapturedImage cimage = attempt.getImage();
        this.thumbnail.setThumbnailImage(cimage);
        this.statusBar.setScore((int)this.attemptList.get(pos).getScore());
    }

    private void updateIndicators(_CaptureCounters counters) {
        this.statusBar.setBest(false);
        this.statusBar.setPass(false);
        this.statusBar.setQSSVisible(false);
        if (!this.qssEnableFlag || this.attemptList.isEmpty()) {
            return;
        }
        CaptureAttempt attempt = this.attemptList.get(counters.getCurrentAttemptPos());
        if (attempt == null) {
            return;
        }
        this.statusBar.setQSSVisible(attempt.getQSS() != null);
        if (attempt.isBestCapture()) {
            this.statusBar.setBest(true);
        }
        this.statusBar.setPass(attempt.isPass());
        this.repaint();
    }

    private void calculateBestAttempt() {
        this.bestAttempt = null;
        if (this.attemptList.isEmpty()) {
            this.fireBestCaptureAttemptChange();
            return;
        }
        double maxScore = 0.0;
        boolean lastPass = false;
        int bestPos = 0;
        for (int i = 0; i < this.attemptList.size(); ++i) {
            CaptureAttempt attempt = this.attemptList.get(i);
            if (attempt == null) continue;
            attempt.setBestCapture(false);
            if (lastPass) {
                if (!attempt.isPass() || !(attempt.getScore() >= maxScore)) continue;
                maxScore = attempt.getScore();
                bestPos = i;
                continue;
            }
            if (attempt.isPass()) {
                maxScore = attempt.getScore();
                bestPos = i;
                lastPass = true;
                continue;
            }
            if (!(attempt.getScore() >= maxScore)) continue;
            maxScore = attempt.getScore();
            bestPos = i;
        }
        this.bestAttempt = this.attemptList.get(bestPos);
        if (this.bestAttempt != null) {
            this.bestAttempt.setBestCapture(true);
        }
        this.fireBestCaptureAttemptChange();
    }
}

