/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.confirm;

import in.gov.uidai.ec.biometrics.device.CaptureRequest;
import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.device.DeviceInfo;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.IDeviceContext;
import in.gov.uidai.ec.biometrics.device.IGenericDeviceContext;
import in.gov.uidai.ec.biometrics.device.INonRDImageListener;
import in.gov.uidai.ec.biometrics.device.SampleFormatInfo;
import in.gov.uidai.ec.biometrics.device.VideoFormatInfo;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.biometrics.postcap.CaptureProcessorFactory;
import in.gov.uidai.ec.biometrics.postcap.ILVSProcessor;
import in.gov.uidai.ec.biometrics.postcap.IQSSProcessor;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.AudioPlayer;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.BioButtonUtils;
import in.gov.uidai.swing.bio.BiometricsFieldBase;
import in.gov.uidai.swing.bio.LabelAndMsgKeys;
import in.gov.uidai.swing.bio.confirm.BiometricFieldControlBarType;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRdStatusBar;
import in.gov.uidai.swing.bio.confirm.ConfirmNonRDActions;
import in.gov.uidai.swing.bio.confirm.IConfirmPositions;
import in.gov.uidai.swing.bio.confirm.IStartCaptureListener;
import in.gov.uidai.swing.bio.confirm.PositionSelector;
import in.gov.uidai.swing.bio.confirm.VerificationStatus;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.bio.player.PreviewPlayer2;
import in.gov.uidai.swing.bio.thumb.CaptureThumbnail;
import in.gov.uidai.swing.bio.thumb.ThumbOverlay;
import in.gov.uidai.swing.border.DashedBorder;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiometricsNonRDField
extends BiometricsFieldBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiometricsNonRDField.class);
    private static final String NAME_START_PANEL = "StartPanel";
    private static final String NAME_END_FORCE_PANEL = "EndForcePanel";
    private static final String NAME_PLAYER_LAYER = "PlayerLayer";
    private static final String NAME_THUMB_LAYER = "ThumbLayer";
    private static final String TIP_NO_START = "Click to start capture";
    private static final String TIP_AFTER_START = "Click to stop capture";
    private static final String KEY_WAIT_ICON = "KEY_CAP_WAIT_ICON";
    private static final String SB_SLAP_ON = "SB_SLAP_ON";
    private static final String SB_IRIS_ON = "SB_IRIS_ON";
    private static final String SB_SLAP_OFF = "SB_SLAP_OFF";
    private static final String SB_IRIS_OFF = "SB_IRIS_OFF";
    private final JLabel titleLabel;
    private final JButton startBut;
    private final JButton endBut;
    private final JButton forceBut;
    private final CardLayout ctrlFlipLayout;
    private final JComponent leftControlBar;
    private final CardLayout mainFlipLayout;
    private final JComponent centerPanel;
    private final CaptureThumbnail thumb;
    private final ThumbOverlay waitOvl;
    private final AbstractPreviewPlayer player;
    private final INonRDImageListener imgHandler;
    private final List<BiConsumer<CaptureAttempt, BiometricPosition>> captureAttemptChangeListeners = new ArrayList<BiConsumer<CaptureAttempt, BiometricPosition>>();
    private final List<IStartCaptureListener> startCaptureListeners = new ArrayList<IStartCaptureListener>();
    private final List<ActionListener> axnList;
    private final BiometricsNonRdStatusBar statusBar;
    public PositionSelector positionSel = new PositionSelector();
    private IDeviceContext devCtxt;
    private String confirmUid;
    private long startTime;
    private long endTime;
    private CaptureAttempt attempt;
    private boolean forcedCapture;
    private boolean captureInProgress;
    private VerificationStatus verifyStat;
    private boolean allowForcedCapture;
    private IConfirmPositions confPos;
    private JLabel controlLabel;

    public BiometricsNonRDField(String title) {
        this(title, BiometricFieldControlBarType.ActionBar);
    }

    public BiometricsNonRDField(String title, BiometricFieldControlBarType biometricFieldControlBarType) {
        TransparentBox controlBar;
        ChangeListener modSwitch = evt -> {
            if (this.captureInProgress) {
                this.stopCapture();
            }
            this.clearCaptureAttempt();
        };
        this.positionSel.addChangeListener(modSwitch);
        this.verifyStat = VerificationStatus.NOT_APPLICABLE;
        this.allowForcedCapture = true;
        this.axnList = new ArrayList<ActionListener>();
        this.imgHandler = new DeviceConfirmImageHandler();
        ConfirmNonRDActions actions = new ConfirmNonRDActions(this);
        this.startBut = BioButtonUtils.createControlButton(actions.getStartAction());
        this.endBut = BioButtonUtils.createControlButton(actions.getStopAction());
        this.forceBut = BioButtonUtils.createControlButton(actions.getForceAction());
        this.statusBar = new BiometricsNonRdStatusBar(actions);
        TransparentBox startPanel = new TransparentBox(new FlowLayout(0, 0, 0));
        startPanel.add(this.startBut);
        TransparentBox endForcePanel = new TransparentBox(new FlowLayout(0, 0, 0));
        endForcePanel.add(this.endBut);
        endForcePanel.add(this.forceBut);
        this.ctrlFlipLayout = new CardLayout();
        this.leftControlBar = new TransparentBox(this.ctrlFlipLayout);
        this.leftControlBar.add((Component)startPanel, NAME_START_PANEL);
        this.leftControlBar.add((Component)endForcePanel, NAME_END_FORCE_PANEL);
        this.titleLabel = new JLabel();
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.titleLabel.setText(title);
        if (biometricFieldControlBarType == BiometricFieldControlBarType.ActionBar) {
            controlBar = this.createActionControlBar();
        } else {
            controlBar = this.createSlabControlBar(title, biometricFieldControlBarType);
        }
        this.thumb = new CaptureThumbnail();
        this.thumb.setBackground(Color.decode("#000000"));
        this.thumb.setOpaque(true);
        this.thumb.setBorder(new DashedBorder().dashInterval("1, 2").lineColor(Color.decode("#bbbbbb")).lineThickness(1.0f));
        this.thumb.setDisabledColor(Color.decode("#cccccc"));
        this.thumb.setCursor(Cursor.getPredefinedCursor(12));
        this.thumb.setToolTipText(TIP_NO_START);
        this.thumb.setAutoCrop(true);
        this.waitOvl = new ThumbOverlay("WaitIndicator").image(KEY_WAIT_ICON).origin(0).offset(0, 0).visible(false);
        this.thumb.addOverlay(this.waitOvl);
        this.player = new PreviewPlayer2();
        this.mainFlipLayout = new CardLayout();
        this.centerPanel = new TransparentBox(this.mainFlipLayout);
        this.centerPanel.add((Component)this.thumb, NAME_THUMB_LAYER);
        this.centerPanel.add((Component)this.player, NAME_PLAYER_LAYER);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)controlBar, "North");
        this.add((Component)this.centerPanel, "Center");
        if (biometricFieldControlBarType == BiometricFieldControlBarType.ActionBar) {
            this.add((Component)this.statusBar, "South");
        }
        MouseAdapter ctrlMouse = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() != 1) {
                    return;
                }
                if (evt.isControlDown() || evt.isShiftDown() || evt.isAltDown()) {
                    return;
                }
                if (evt.isAltGraphDown() || evt.isMetaDown()) {
                    return;
                }
                if (!BiometricsNonRDField.this.captureInProgress) {
                    BiometricsNonRDField.this.startBut.doClick();
                } else if (BiometricsNonRDField.this.allowForcedCapture) {
                    BiometricsNonRDField.this.forceBut.doClick();
                } else {
                    BiometricsNonRDField.this.endBut.doClick();
                }
            }
        };
        this.thumb.addMouseListener(ctrlMouse);
        this.player.addMouseListener(ctrlMouse);
    }

    public void addStartCaptureListener(IStartCaptureListener listener) {
        this.startCaptureListeners.add(listener);
    }

    public void fireStartCaptureListener() {
        this.startCaptureListeners.forEach(l -> l.accept(this.getLabel()));
    }

    private TransparentBox createSlabControlBar(String title, BiometricFieldControlBarType biometricFieldControlBarType) {
        this.setSingleBodyPartCaptureView();
        TransparentBox transparentBox = new TransparentBox(new BorderLayout(5, 0));
        ImageIcon icon = biometricFieldControlBarType == BiometricFieldControlBarType.FingerSlabBar ? ImageIconCache.getInst().getIcon(SB_SLAP_OFF) : ImageIconCache.getInst().getIcon(SB_IRIS_OFF);
        this.controlLabel = new JLabel(title, icon, 0);
        this.controlLabel.setForeground(Color.WHITE);
        transparentBox.add((Component)this.controlLabel, "West");
        return transparentBox;
    }

    private TransparentBox createActionControlBar() {
        TransparentBox controlBar = new TransparentBox(new BorderLayout(5, 0));
        controlBar.add((Component)this.leftControlBar, "West");
        controlBar.add((Component)this.titleLabel, "Center");
        controlBar.add((Component)this.positionSel.getSelector(), "East");
        return controlBar;
    }

    private void setSingleBodyPartCaptureView() {
        LinearGradientBackground bioBg = new LinearGradientBackground().borderSize(0.0f).roundingSize(5, 5).gradientColors("#84a9d8, #84a9d8").gradientStops("0, 1").direction(1);
        this.setBackground(bioBg);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    public void setDeviceLifeCycleListener(DeviceLifeCycleListener deviceLifeCycleListener, DeviceType subscribedDeviceType) {
        if (deviceLifeCycleListener != null) {
            deviceLifeCycleListener.addDeviceStartedListener(d -> this.deviceStatus(d, subscribedDeviceType, true));
            deviceLifeCycleListener.addDeviceStoppedListener(d -> this.deviceStatus(d, subscribedDeviceType, false));
        }
    }

    private void deviceStatus(DeviceType deviceType, DeviceType subscribedDeviceType, boolean connected) {
        if (deviceType == DeviceType.FINGERPRINT && subscribedDeviceType == DeviceType.FINGERPRINT) {
            this.controlLabel.setIcon(ImageIconCache.getInst().getIcon(connected ? SB_SLAP_ON : SB_SLAP_OFF));
        }
        if (deviceType == DeviceType.IRIS && subscribedDeviceType == DeviceType.IRIS) {
            this.controlLabel.setIcon(ImageIconCache.getInst().getIcon(connected ? SB_IRIS_ON : SB_IRIS_OFF));
        }
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.startBut != null) {
            this.startBut.setEnabled(enabled);
        }
        if (this.statusBar != null) {
            this.statusBar.setEnabled(enabled);
        }
        if (this.thumb != null) {
            this.thumb.setEnabled(enabled);
        }
        if (!enabled && this.thumb != null) {
            this.thumb.setToolTipText(null);
        }
    }

    public void addQSSActionListener(ActionListener l) {
        this.axnList.add(l);
    }

    public void addCaptureAttemptChangeListeners(BiConsumer<CaptureAttempt, BiometricPosition> delegate) {
        this.captureAttemptChangeListeners.add(delegate);
    }

    public void allowForcedCapture(boolean flag) {
        this.allowForcedCapture = flag;
        this.forceBut.setVisible(flag);
        if (this.player != null) {
            this.player.allowForcedCapture(flag);
        }
    }

    public void hidePositionSelector() {
        this.positionSel.setVisible(false);
    }

    public void clearCaptureAttempt() {
        this.attempt = null;
        this.forcedCapture = false;
        this.fireCaptureAttemptChange();
        this.doShowThumbNail();
    }

    public void setConfirmUid(String uid) {
        this.confirmUid = uid;
    }

    public IConfirmPositions getConfirmPositions() {
        return this.confPos;
    }

    public void setConfirmPositions(IConfirmPositions cnfPos) {
        this.confPos = cnfPos;
        this.positionSel.setConfirmPositions(cnfPos);
    }

    public CaptureAttempt getCaptureAttempt() {
        return this.attempt;
    }

    public VerificationStatus getVerificationStatus() {
        return this.verifyStat;
    }

    public String getLabel() {
        return this.titleLabel.getText();
    }

    public void setLabel(String str) {
        this.titleLabel.setText(str);
    }

    public void localize(L10nDecorator deco) {
        String titleText = this.titleLabel.getText();
        deco.localize(this.titleLabel, (Object)titleText, new Object[0]);
        deco.localizeToolTip(this.startBut, (Object)LabelAndMsgKeys.TT_CAPTURE_START, new Object[0]);
        deco.localizeToolTip(this.endBut, (Object)LabelAndMsgKeys.TT_CAPTURE_STOP, new Object[0]);
        deco.localizeToolTip(this.forceBut, (Object)LabelAndMsgKeys.TT_CAPTURE_FORCE, new Object[0]);
        this.statusBar.localize(deco);
    }

    void doStartCapture() {
        List sfiList;
        if (this.captureInProgress) {
            return;
        }
        LOGGER.debug("within starting capture action handler");
        this.resetMetaData();
        this.doShowThumbNail();
        this.fireStartCaptureListener();
        this.startTime = System.currentTimeMillis();
        IClientDeviceManager deviceManager = this.getClientDeviceManager();
        if (deviceManager == null || this.player == null) {
            LOGGER.debug("client device manager or preview player is null");
            return;
        }
        if (this.devCtxt != null) {
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
            this.devCtxt = null;
        }
        DeviceType devType = this.positionSel.getDeviceType();
        this.devCtxt = deviceManager.getDeviceContext(devType);
        if (this.devCtxt == null) {
            LOGGER.debug("device context not found for: " + devType.name());
            switch (devType) {
                case FINGERPRINT: {
                    this.displayMessage(LabelAndMsgKeys.MSG_NODEV_FINGER.toString());
                    break;
                }
                case PHOTO: {
                    this.displayMessage(LabelAndMsgKeys.MSG_NODEV_CAMERA.toString());
                    break;
                }
                case IRIS: {
                    this.displayMessage(LabelAndMsgKeys.MSG_NODEV_IRIS.toString());
                }
            }
            return;
        }
        this.devCtxt.addImageListener(this.imgHandler);
        this.player.startPreview((IGenericDeviceContext)this.devCtxt);
        BiometricPosition biopos = this.positionSel.getBiometricPosition();
        if (biopos.equals((Object)BiometricPosition.ANY_FINGER) || biopos.equals((Object)BiometricPosition.UNKNOWN)) {
            biopos = BiometricPosition.LEFT_INDEX;
        }
        CaptureRequest request = new CaptureRequest();
        request.setBiometricPosition(biopos);
        List vfiList = this.devCtxt.getDeviceInformation().getVideoFormats();
        if (vfiList != null && vfiList.size() > 0) {
            request.setVideoFormatId(((VideoFormatInfo)vfiList.get(0)).getVideoFormatId());
        }
        if ((sfiList = this.devCtxt.getDeviceInformation().getSampleFormats()) != null && sfiList.size() > 0) {
            request.setSampleFormatId(((SampleFormatInfo)sfiList.get(0)).getFormatId());
        }
        request.setManualCapture(true);
        this.ctrlFlipLayout.show(this.leftControlBar, NAME_END_FORCE_PANEL);
        if (!this.devCtxt.startCapture(request)) {
            this.ctrlFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
        } else {
            this.startTime = System.currentTimeMillis();
        }
        this.mainFlipLayout.show(this.centerPanel, NAME_PLAYER_LAYER);
        this.captureInProgress = true;
        this.thumb.setToolTipText(TIP_AFTER_START);
        this.fireCaptureStarted();
    }

    public void stopCapture() {
        if (this.devCtxt == null) {
            return;
        }
        try {
            this.doEndCapture();
            this.thumb.setToolTipText(TIP_NO_START);
        }
        catch (Exception e) {
            LOGGER.debug("error in external stop capture", (Throwable)e);
        }
    }

    void doEndCapture() {
        this.resetMetaData();
        this.mainFlipLayout.show(this.centerPanel, NAME_THUMB_LAYER);
        if (this.devCtxt != null) {
            this.devCtxt.removeImageListener(this.imgHandler);
            if (!this.devCtxt.endCapture()) {
                LOGGER.debug("failed to end capture");
            }
        }
        if (this.player != null) {
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
            this.player.setVisible(false);
        }
        this.devCtxt = null;
        this.ctrlFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
        this.thumb.setToolTipText(TIP_NO_START);
        this.fireCaptureStopped();
        this.startBut.setEnabled(true);
    }

    void doForceCapture() {
        this.forcedCapture = true;
        this.mainFlipLayout.show(this.centerPanel, NAME_THUMB_LAYER);
        if (this.devCtxt == null) {
            return;
        }
        boolean success = this.devCtxt.forceCapture();
        this.player.endPreview((IGenericDeviceContext)this.devCtxt);
        this.devCtxt = null;
        this.ctrlFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
        if (success) {
            LOGGER.debug("force capture requested");
            this.thumb.setToolTipText(TIP_NO_START);
            this.fireCaptureForced();
        } else {
            LOGGER.debug("failed to force capture");
            this.setWait(false);
            this.forcedCapture = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate() {
        this.fireComponentBusy();
        this.waitOvl.visible(true);
        if (StringUtils.isBlank((String)this.confirmUid)) {
            this.waitOvl.visible(false);
            this.fireComponentReady();
            return false;
        }
        DeviceType deviceType = this.positionSel.getDeviceType();
        BiometricPosition position = null;
        String authType = null;
        switch (deviceType) {
            case IRIS: {
                position = BiometricPosition.LEFT_IRIS;
                authType = "iris";
                break;
            }
            case FINGERPRINT: {
                position = BiometricPosition.UNKNOWN;
                authType = "fingerprint";
            }
        }
        try {
            ILVSProcessor lproc = new CaptureProcessorFactory(deviceType, null).createLVSProcessor(this.attempt.getImage(), position);
            boolean bl = lproc.verify(this.confirmUid, authType);
            return bl;
        }
        finally {
            this.waitOvl.visible(false);
            this.fireComponentReady();
        }
    }

    void doQSSActionPerformed(ActionEvent evt) {
        this.axnList.forEach(l -> {
            try {
                l.actionPerformed(evt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void fireCaptureAttemptChange() {
        this.captureAttemptChangeListeners.forEach(listener -> listener.accept(this.attempt, this.positionSel.getBiometricPosition()));
    }

    private void resetMetaData() {
        this.startTime = Long.MIN_VALUE;
        this.endTime = Long.MIN_VALUE;
        this.forcedCapture = false;
        this.captureInProgress = false;
        this.attempt = null;
    }

    private void doShowThumbNail() {
        if (this.attempt != null) {
            this.thumb.setThumbnailImage(this.attempt.getImage());
            this.statusBar.setScore((int)this.attempt.getScore());
            this.statusBar.setPass(this.attempt.isPass());
            this.statusBar.setQSSVisible(this.attempt.getQSS() != null);
        } else {
            this.thumb.setThumbnailImage(null);
            this.statusBar.setScore(0);
            this.statusBar.clearPass();
            this.statusBar.setQSSVisible(false);
        }
    }

    private void doImageReceived(CapturedImage cimage) {
        ILVSProcessor lproc;
        BiometricPosition position;
        LOGGER.debug("captured image received");
        this.player.setVisible(false);
        this.ctrlFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
        this.endTime = System.currentTimeMillis();
        if (cimage == null) {
            LOGGER.warn("no captured image");
            return;
        }
        if (ArrayUtils.isEmpty((byte[])cimage.getImageData())) {
            LOGGER.warn("no data in captured image");
            return;
        }
        CaptureProcessorFactory cpf = new CaptureProcessorFactory(this.positionSel.getDeviceType(), null);
        IQSSProcessor qproc = cpf.createQSSProcessor(cimage, this.positionSel.getBiometricPosition());
        boolean procStat = qproc.process();
        if (!procStat) {
            this.displayMessage(LabelAndMsgKeys.MSG_QSS_ERROR.toString());
        }
        boolean pass = (position = qproc.getBiometricPosition()) != null && (position.equals((Object)BiometricPosition.LEFT_IRIS) || position.equals((Object)BiometricPosition.RIGHT_IRIS)) ? qproc.getCapturedImage().getQuality() >= 52 : qproc.getCapturedImage().getQuality() >= 50;
        AudioPlayer.getInstance().play(pass ? "res/cui/sounds/cap-success.wav" : "res/cui/sounds/cap-failure.wav");
        CaptureAttempt capat = new CaptureAttempt();
        IDeviceContext dc = this.getClientDeviceManager().getDeviceContext(this.positionSel.getDeviceType());
        DeviceInfo devInfo = null;
        if (dc != null) {
            devInfo = dc.getDeviceInformation();
        }
        capat.setDeviceInfo(devInfo);
        capat.setStartTime(this.startTime);
        capat.setEndTime(this.endTime);
        capat.setForcedCapture(this.forcedCapture);
        capat.setBestCapture(true);
        if (!procStat) {
            capat.setScore(0.0);
            capat.setPass(true);
        } else {
            capat.setScore((double)qproc.getCapturedImage().getQuality());
            capat.setPass(pass);
            capat.setImage(qproc.getCapturedImage());
            capat.setQSS(qproc.getQSSData());
        }
        this.attempt = capat;
        LOGGER.debug("capture completed for " + this.getLabel() + " with score " + capat.getScore());
        this.fireCaptureAttemptChange();
        this.verifyStat = StringUtils.isBlank((String)this.confirmUid) ? VerificationStatus.NOT_APPLICABLE : ((lproc = cpf.createLVSProcessor(cimage, BiometricPosition.UNKNOWN)).verify(this.confirmUid, this.positionSel.getDeviceType().toString()) ? VerificationStatus.OK : VerificationStatus.ERROR);
    }

    private void setWait(boolean flag) {
        this.startBut.setEnabled(!flag);
        this.waitOvl.visible(flag);
        this.thumb.setEnabled(!flag);
    }

    private void displayMessage(String rbKey) {
        L10nOptionPaneBuilder.getInstance().showError(rbKey, this, new Object[0]);
    }

    static {
        ImageIconCache.getInst().addIcon(KEY_WAIT_ICON, "res/images/cap-wait.gif");
        ImageIconCache.getInst().addIcon(SB_SLAP_ON, "res/images/sb-slap.png");
        ImageIconCache.getInst().addIcon(SB_IRIS_ON, "res/images/sb-iris.png");
        ImageIconCache.getInst().addIcon(SB_SLAP_OFF, "res/images/sb-slap-off.png");
        ImageIconCache.getInst().addIcon(SB_IRIS_OFF, "res/images/sb-iris-off.png");
    }

    private class DeviceConfirmImageHandler
    implements INonRDImageListener {
        private DeviceConfirmImageHandler() {
        }

        public void imageReceived(CapturedImage[] cimage) {
            BiometricsNonRDField.this.captureInProgress = false;
            BiometricsNonRDField.this.thumb.setToolTipText(BiometricsNonRDField.TIP_NO_START);
            try {
                BiometricsNonRDField.this.setWait(true);
                BiometricsNonRDField.this.fireComponentBusy();
                if (cimage != null && cimage.length > 0) {
                    BiometricsNonRDField.this.doImageReceived(cimage[0]);
                }
            }
            finally {
                BiometricsNonRDField.this.fireComponentReady();
                BiometricsNonRDField.this.setWait(false);
                BiometricsNonRDField.this.doShowThumbNail();
                if (BiometricsNonRDField.this.devCtxt != null) {
                    BiometricsNonRDField.this.devCtxt.removeImageListener(BiometricsNonRDField.this.imgHandler);
                    BiometricsNonRDField.this.devCtxt = null;
                }
            }
            if (BiometricsNonRDField.this.attempt != null) {
                BiometricsNonRDField.this.fireSampleReceived(new String[]{BiometricsNonRDField.this.attempt.getId()});
            }
        }
    }
}

