/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.confirm;

import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.BioButtonUtils;
import in.gov.uidai.swing.bio.LabelAndMsgKeys;
import in.gov.uidai.swing.bio.confirm.ConfirmNonRDActions;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

class BiometricsNonRdStatusBar
extends TransparentBox {
    private final JProgressBar scoreBar;
    private final JButton qssBut;
    private final JLabel scoreLabel;

    BiometricsNonRdStatusBar(ConfirmNonRDActions confirmNonRDActions) {
        double[][] guides = new double[][]{{30.0, 2.0, -1.0, 2.0, 20.0}, {0.0, 25.0, 0.0}};
        this.setLayout(new TableLayout(guides));
        this.scoreLabel = new JLabel("Score");
        this.add((Component)this.scoreLabel, "0, 1, full, center");
        this.scoreBar = new JProgressBar(0, 100);
        this.scoreBar.setStringPainted(true);
        this.qssBut = BioButtonUtils.createControlButton(confirmNonRDActions.getQSSAction());
        this.qssBut.setVisible(false);
        this.add((Component)this.scoreBar, "2, 1, full, full");
        this.add((Component)this.qssBut, "4, 1, full, full");
    }

    void setPass(boolean flag) {
        this.scoreBar.putClientProperty("status", flag ? "pass" : "fail");
    }

    void clearPass() {
        this.scoreBar.putClientProperty("status", null);
    }

    void setScore(int score) {
        this.scoreBar.setValue(score);
    }

    void setQSSVisible(boolean flag) {
        this.qssBut.setVisible(flag);
    }

    void localize(L10nDecorator deco) {
        deco.localize(this.scoreLabel, (Object)LabelAndMsgKeys.LABEL_SCORE, new Object[0]);
        deco.localizeToolTip(this.qssBut, (Object)LabelAndMsgKeys.TT_QSS, new Object[0]);
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.qssBut.setEnabled(enabled);
    }
}

