/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.confirm;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IGenericDeviceContext;
import in.gov.uidai.ec.biometrics.device.INonRDImageListener;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.biometrics.registereddevice.IRDImageListener;
import in.gov.uidai.ec.biometrics.registereddevice.RdCaptureException;
import in.gov.uidai.ec.biometrics.registereddevice.RdCaptureResponse;
import in.gov.uidai.ec.biometrics.registereddevice.RegisteredDeviceContext;
import in.gov.uidai.ec.biometrics.registereddevice.RegisteredDeviceManager;
import in.gov.uidai.ec.rd.device.xml.PidData;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.swing.AudioPlayer;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.BioButtonUtils;
import in.gov.uidai.swing.bio.BiometricsFieldBase;
import in.gov.uidai.swing.bio.LabelAndMsgKeys;
import in.gov.uidai.swing.bio.confirm.BiometricFieldControlBarType;
import in.gov.uidai.swing.bio.confirm.BiometricsRdStatusBar;
import in.gov.uidai.swing.bio.confirm.ConfirmRDActions;
import in.gov.uidai.swing.bio.confirm.IConfirmPositions;
import in.gov.uidai.swing.bio.confirm.PositionSelector;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.bio.player.PreviewPlayer2;
import in.gov.uidai.swing.bio.thumb.CaptureThumbnail;
import in.gov.uidai.swing.bio.thumb.ThumbOverlay;
import in.gov.uidai.swing.border.DashedBorder;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiometricsRDField
extends BiometricsFieldBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiometricsRDField.class);
    private static final String NAME_START_PANEL = "StartPanel";
    private static final String NAME_END_FORCE_PANEL = "EndForcePanel";
    private static final String NAME_PLAYER_LAYER = "PlayerLayer";
    private static final String NAME_THUMB_LAYER = "ThumbLayer";
    private static final String TIP_NO_START = "Click to start capture";
    private static final String KEY_RD_TEMP_IMAGE = "KEY_RD_TEMP_IMAGE";
    private static final String KEY_WAIT_ICON = "KEY_CAP_WAIT_ICON";
    private static final String SB_SLAP_ON = "SB_SLAP_ON";
    private static final String SB_IRIS_ON = "SB_IRIS_ON";
    private static final String SB_SLAP_OFF = "SB_SLAP_OFF";
    private static final String SB_IRIS_OFF = "SB_IRIS_OFF";
    private final CardLayout mainFlipLayout;
    private final JComponent centerPanel;
    private final CaptureThumbnail thumb;
    private final ThumbOverlay waitOvl;
    private final AbstractPreviewPlayer player;
    private final List<BiConsumer<CaptureAttempt, String>> captureAttemptChangeListeners = new ArrayList<BiConsumer<CaptureAttempt, String>>();
    private final JLabel titleLabel;
    private final JButton startBut;
    private final JButton endBut;
    private final CardLayout ctrlFlipLayout;
    private final JComponent leftControlBar;
    private final INonRDImageListener imgHandler;
    private final PositionSelector positionSel = new PositionSelector();
    private final BiometricsRdStatusBar statusBar;
    private RegisteredDeviceContext devCtxt;
    private String confirmUid;
    private long startTime;
    private long endTime;
    private CaptureAttempt attempt;
    private boolean forcedCapture;
    private boolean captureInProgress;
    private boolean isKyc;
    private String capRdPid;
    private CapturedImage capImg;
    private PidData pidData;
    private IConfirmPositions confPos;
    private JLabel controlLabel;
    private String otpForPidOptions;

    public BiometricsRDField(String title) {
        this(title, null, null, BiometricFieldControlBarType.ActionBar);
    }

    public BiometricsRDField(String title, BiometricFieldControlBarType biometricFieldControlBarType) {
        this(title, null, null, biometricFieldControlBarType);
    }

    public BiometricsRDField(String title, JButton verifyButton, JLabel verifyLabel, BiometricFieldControlBarType biometricFieldControlBarType) {
        TransparentBox controlBar;
        ChangeListener modSwitch = evt -> this.clearCaptureAttempt();
        this.positionSel.addChangeListener(modSwitch);
        this.imgHandler = new DeviceConfirmImageHandler();
        ConfirmRDActions actions = new ConfirmRDActions(this);
        this.startBut = BioButtonUtils.createControlButton(actions.getStartAction());
        this.endBut = BioButtonUtils.createControlButton(actions.getStopAction());
        TransparentBox startPanel = new TransparentBox(new FlowLayout(0, 0, 0));
        startPanel.add(this.startBut);
        TransparentBox endForcePanel = new TransparentBox(new FlowLayout(0, 0, 0));
        endForcePanel.add(this.endBut);
        this.ctrlFlipLayout = new CardLayout();
        this.leftControlBar = new TransparentBox(this.ctrlFlipLayout);
        this.leftControlBar.add((Component)startPanel, NAME_START_PANEL);
        this.leftControlBar.add((Component)endForcePanel, NAME_END_FORCE_PANEL);
        this.titleLabel = new JLabel();
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.titleLabel.setText(title);
        if (biometricFieldControlBarType == BiometricFieldControlBarType.ActionBar) {
            controlBar = this.createActionControlBar();
        } else {
            controlBar = this.createSlabControlBar(title, biometricFieldControlBarType);
        }
        this.thumb = new CaptureThumbnail();
        this.thumb.setBackground(Color.decode("#000000"));
        this.thumb.setOpaque(true);
        this.thumb.setBorder(new DashedBorder().dashInterval("1, 2").lineColor(Color.decode("#bbbbbb")).lineThickness(1.0f));
        this.thumb.setCursor(Cursor.getPredefinedCursor(12));
        this.thumb.setToolTipText(TIP_NO_START);
        this.waitOvl = new ThumbOverlay("WaitIndicator").image(KEY_WAIT_ICON).origin(0).offset(0, 0).visible(false);
        this.thumb.addOverlay(this.waitOvl);
        this.player = new PreviewPlayer2();
        this.mainFlipLayout = new CardLayout();
        this.centerPanel = new TransparentBox(this.mainFlipLayout);
        this.centerPanel.add((Component)this.thumb, NAME_THUMB_LAYER);
        this.centerPanel.add((Component)this.player, NAME_PLAYER_LAYER);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)controlBar, "North");
        this.add((Component)this.centerPanel, "Center");
        this.statusBar = new BiometricsRdStatusBar(verifyButton, verifyLabel);
        if (biometricFieldControlBarType == BiometricFieldControlBarType.ActionBar) {
            this.add((Component)this.statusBar, "South");
        }
        MouseAdapter ctrlMouse = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() != 1) {
                    return;
                }
                if (evt.isControlDown() || evt.isShiftDown() || evt.isAltDown()) {
                    return;
                }
                if (evt.isAltGraphDown() || evt.isMetaDown()) {
                    return;
                }
                if (!BiometricsRDField.this.captureInProgress) {
                    BiometricsRDField.this.startBut.doClick();
                } else {
                    BiometricsRDField.this.endBut.doClick();
                }
            }
        };
        this.thumb.addMouseListener(ctrlMouse);
        this.player.addMouseListener(ctrlMouse);
    }

    public void enableKyc() {
        this.isKyc = true;
    }

    private TransparentBox createSlabControlBar(String title, BiometricFieldControlBarType biometricFieldControlBarType) {
        this.setSingleBodyPartCaptureView();
        TransparentBox transparentBox = new TransparentBox(new BorderLayout(5, 0));
        ImageIcon icon = biometricFieldControlBarType == BiometricFieldControlBarType.FingerSlabBar ? ImageIconCache.getInst().getIcon(SB_SLAP_OFF) : ImageIconCache.getInst().getIcon(SB_IRIS_OFF);
        this.controlLabel = new JLabel(title, icon, 0);
        this.controlLabel.setForeground(Color.WHITE);
        transparentBox.add((Component)this.controlLabel, "West");
        return transparentBox;
    }

    private TransparentBox createActionControlBar() {
        TransparentBox controlBar = new TransparentBox(new BorderLayout(5, 0));
        controlBar.add((Component)this.leftControlBar, "West");
        controlBar.add((Component)this.titleLabel, "Center");
        controlBar.add((Component)this.positionSel.getSelector(), "East");
        return controlBar;
    }

    public void hidePositionSelector() {
        this.positionSel.setVisible(false);
    }

    private void setSingleBodyPartCaptureView() {
        LinearGradientBackground bioBg = new LinearGradientBackground().borderSize(0.0f).roundingSize(5, 5).gradientColors("#84a9d8, #84a9d8").gradientStops("0, 1").direction(1);
        this.setBackground(bioBg);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    public void setDeviceLifeCycleListener(DeviceLifeCycleListener deviceLifeCycleListener, DeviceType subscribedDeviceType) {
        if (deviceLifeCycleListener != null) {
            deviceLifeCycleListener.addDeviceStartedListener(d -> this.deviceStatus(d, subscribedDeviceType, true));
            deviceLifeCycleListener.addDeviceStoppedListener(d -> this.deviceStatus(d, subscribedDeviceType, false));
        }
    }

    private void deviceStatus(DeviceType deviceType, DeviceType subscribedDeviceType, boolean connected) {
        if (deviceType == DeviceType.FINGERPRINT_AUTH && subscribedDeviceType == DeviceType.FINGERPRINT_AUTH) {
            this.controlLabel.setIcon(ImageIconCache.getInst().getIcon(connected ? SB_SLAP_ON : SB_SLAP_OFF));
        }
        if (deviceType == DeviceType.IRIS_AUTH && subscribedDeviceType == DeviceType.IRIS_AUTH) {
            this.controlLabel.setIcon(ImageIconCache.getInst().getIcon(connected ? SB_IRIS_ON : SB_IRIS_OFF));
        }
    }

    public void setOtpForPidOptions(String otpForPidOptions) {
        this.otpForPidOptions = otpForPidOptions;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.startBut != null) {
            this.startBut.setEnabled(enabled);
        }
        if (this.statusBar != null) {
            this.statusBar.setEnabled(enabled);
        }
        if (this.thumb != null) {
            this.thumb.setEnabled(enabled);
        }
        if (!enabled && this.thumb != null) {
            this.thumb.setToolTipText(null);
        }
    }

    public void enableStartButton(boolean flag) {
        this.startBut.setEnabled(flag);
    }

    public void addCaptureAttemptChangeListeners(BiConsumer<CaptureAttempt, String> delegate) {
        this.captureAttemptChangeListeners.add(delegate);
    }

    public void clearCaptureAttempt() {
        if (this.captureInProgress) {
            this.stopCapture();
        }
        this.attempt = null;
        this.forcedCapture = false;
        this.fireCaptureAttemptChange();
        this.doShowThumbNail();
    }

    public String getConfirmUid() {
        return this.confirmUid;
    }

    public void setConfirmUid(String uid) {
        this.confirmUid = uid;
    }

    public void setConfirmPositions(IConfirmPositions cnfPos) {
        this.confPos = cnfPos;
        this.positionSel.setConfirmPositions(cnfPos);
    }

    public CaptureAttempt getCaptureAttempt() {
        return this.attempt;
    }

    public PositionSelector getPositionSel() {
        return this.positionSel;
    }

    public void localize(L10nDecorator deco) {
        String titleText = this.titleLabel.getText();
        deco.localize(this.titleLabel, (Object)titleText, new Object[0]);
        deco.localizeToolTip(this.startBut, (Object)LabelAndMsgKeys.TT_CAPTURE_START, new Object[0]);
        deco.localizeToolTip(this.endBut, (Object)LabelAndMsgKeys.TT_CAPTURE_STOP, new Object[0]);
        this.statusBar.localize(deco);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartCapture() {
        if (this.captureInProgress) {
            return;
        }
        LOGGER.debug("within starting capture action handler");
        this.resetMetaData();
        this.clearCaptureAttempt();
        this.startTime = System.currentTimeMillis();
        RegisteredDeviceManager deviceManager = this.getClientDeviceManager().getRegisteredDeviceManager();
        if (deviceManager == null || this.player == null) {
            LOGGER.debug("client device manager or preview player is null");
            return;
        }
        if (this.devCtxt != null) {
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
            this.devCtxt = null;
        }
        DeviceType devType = this.positionSel.getDeviceType();
        this.devCtxt = deviceManager.getDeviceContext(devType);
        if (this.devCtxt == null) {
            LOGGER.debug("registered device context not found for: " + devType.name());
            switch (devType) {
                case FINGERPRINT_AUTH: {
                    L10nOptionPaneBuilder.getInstance().showError(LabelAndMsgKeys.MSG_NO_RDDEV_FINGER.toString(), this, new Object[0]);
                    return;
                }
                case IRIS_AUTH: {
                    L10nOptionPaneBuilder.getInstance().showError(LabelAndMsgKeys.MSG_NO_RDDEV_IRIS.toString(), this, new Object[0]);
                    return;
                }
            }
        }
        this.devCtxt.addImageListener(this.imgHandler);
        this.player.startPreview((IGenericDeviceContext)this.devCtxt);
        this.ctrlFlipLayout.show(this.leftControlBar, NAME_END_FORCE_PANEL);
        try {
            this.captureInProgress = true;
            this.devCtxt.startCapture(deviceManager.getRdManagerPreference().getRegisteredDeviceEnvironment(), devType, this.otpForPidOptions, this.isKyc);
        }
        catch (RdCaptureException e) {
            LOGGER.error("Failed to get registered device capture response. ", (Throwable)e);
            this.attempt = null;
            L10nOptionPaneBuilder.getInstance().showError(e.getMessage(), this, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get registered device capture response. ", (Throwable)e);
            this.attempt = null;
            L10nOptionPaneBuilder.getInstance().showError("Failed to get registered device capture response.", this, new Object[0]);
        }
        finally {
            this.captureInProgress = false;
            this.fireCaptureAttemptChange();
            this.doShowThumbNail();
            this.ctrlFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
        }
    }

    private void stopCapture() {
        if (this.devCtxt == null) {
            return;
        }
        try {
            this.doEndCapture();
            this.thumb.setToolTipText(TIP_NO_START);
        }
        catch (Exception e) {
            LOGGER.debug("error in external stop capture", (Throwable)e);
        }
    }

    void doEndCapture() {
        this.resetMetaData();
        this.mainFlipLayout.show(this.centerPanel, NAME_THUMB_LAYER);
        if (this.devCtxt != null && !this.devCtxt.endCapture()) {
            LOGGER.debug("failed to end capture");
        }
        if (this.player != null) {
            this.player.endPreview((IGenericDeviceContext)this.devCtxt);
            this.player.setVisible(false);
        }
        this.devCtxt.removeImageListener(this.imgHandler);
        this.devCtxt = null;
        this.ctrlFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
        this.thumb.setToolTipText(TIP_NO_START);
        this.fireCaptureStopped();
        this.startBut.setEnabled(true);
    }

    private void fireCaptureAttemptChange() {
        this.captureAttemptChangeListeners.forEach(listener -> listener.accept(this.attempt, this.capRdPid));
    }

    private void resetMetaData() {
        this.startTime = Long.MIN_VALUE;
        this.endTime = Long.MIN_VALUE;
        this.forcedCapture = false;
        this.captureInProgress = false;
    }

    private void doShowThumbNail() {
        if (this.attempt != null) {
            this.thumb.setThumbnailImage(this.attempt.getImage());
            this.statusBar.setScore((int)this.attempt.getScore());
            this.statusBar.setPass(this.attempt.isPass());
        } else {
            this.thumb.setThumbnailImage(null);
            this.statusBar.setScore(0);
            this.statusBar.clearPass();
        }
    }

    private void doImageReceived(CapturedImage cimage) {
        LOGGER.debug("captured image received");
        this.player.setVisible(false);
        this.ctrlFlipLayout.show(this.leftControlBar, NAME_START_PANEL);
        this.endTime = System.currentTimeMillis();
        if (cimage == null) {
            LOGGER.warn("no captured image");
            return;
        }
        if (ArrayUtils.isEmpty((byte[])cimage.getImageData())) {
            LOGGER.warn("no data in captured image");
            return;
        }
        AudioPlayer.getInstance().play("res/cui/sounds/cap-success.wav");
        CaptureAttempt capat = new CaptureAttempt();
        capat.setImage(cimage);
        capat.setDevRdInfo(this.devCtxt.getDeviceInformation());
        capat.setStartTime(this.startTime);
        capat.setEndTime(this.endTime);
        capat.setForcedCapture(this.forcedCapture);
        capat.setPass(true);
        capat.setScore(Double.parseDouble(this.pidData.getResp().getqScore()));
        this.attempt = capat;
    }

    private void setWait(boolean flag) {
        this.startBut.setEnabled(!flag);
        this.waitOvl.visible(flag);
        this.thumb.setEnabled(!flag);
    }

    public String getCapturedRd() {
        return this.capRdPid;
    }

    public PidData getPidData() {
        return this.pidData;
    }

    static {
        ImageIconCache.getInst().addIcon(KEY_WAIT_ICON, "res/images/cap-wait.gif");
        ImageIconCache.getInst().addIcon(KEY_RD_TEMP_IMAGE, "res/cui/images/bio/rd_temp_image.png");
        ImageIconCache.getInst().addIcon(SB_SLAP_ON, "res/images/sb-slap.png");
        ImageIconCache.getInst().addIcon(SB_IRIS_ON, "res/images/sb-iris.png");
        ImageIconCache.getInst().addIcon(SB_SLAP_OFF, "res/images/sb-slap-off.png");
        ImageIconCache.getInst().addIcon(SB_IRIS_OFF, "res/images/sb-iris-off.png");
    }

    private class DeviceConfirmImageHandler
    implements INonRDImageListener,
    IRDImageListener {
        private DeviceConfirmImageHandler() {
        }

        public void imageReceived(CapturedImage[] cimage) {
            BiometricsRDField.this.captureInProgress = false;
            BiometricsRDField.this.thumb.setToolTipText(BiometricsRDField.TIP_NO_START);
            try {
                BiometricsRDField.this.setWait(true);
                BiometricsRDField.this.fireComponentBusy();
                if (cimage != null && cimage.length > 0) {
                    BiometricsRDField.this.doImageReceived(cimage[0]);
                }
            }
            finally {
                BiometricsRDField.this.fireComponentReady();
                BiometricsRDField.this.setWait(false);
                BiometricsRDField.this.doShowThumbNail();
                if (BiometricsRDField.this.devCtxt != null) {
                    BiometricsRDField.this.devCtxt.removeImageListener(BiometricsRDField.this.imgHandler);
                    BiometricsRDField.this.devCtxt = null;
                }
            }
            if (BiometricsRDField.this.attempt != null) {
                BiometricsRDField.this.fireSampleReceived(new String[]{BiometricsRDField.this.attempt.getId()});
            }
        }

        public void imageReceived(RdCaptureResponse rdCaptureResponse) {
            try {
                Image imag = ImageIconCache.getInst().getIcon(BiometricsRDField.KEY_RD_TEMP_IMAGE).getImage();
                BiometricsRDField.this.capImg = new CapturedImage();
                BiometricsRDField.this.capImg.setHeight(imag.getHeight(null));
                BiometricsRDField.this.capImg.setWidth(imag.getWidth(null));
                BufferedImage bimage = new BufferedImage(imag.getWidth(null), imag.getHeight(null), 5);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Graphics2D g = bimage.createGraphics();
                g.drawImage(imag, 0, 0, Color.white, null);
                g.dispose();
                ImageIO.write((RenderedImage)bimage, "png", baos);
                baos.flush();
                byte[] imageInByte = baos.toByteArray();
                baos.close();
                BiometricsRDField.this.capImg.setOriginalData(imageInByte);
                BiometricsRDField.this.capImg.setImageData(imageInByte);
                BiometricsRDField.this.capImg.setEncoding("Y");
                BiometricsRDField.this.thumb.setAutoCrop(false);
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
            CapturedImage[] capturedImages = new CapturedImage[]{BiometricsRDField.this.capImg};
            BiometricsRDField.this.capRdPid = rdCaptureResponse.getCapRdPid();
            BiometricsRDField.this.pidData = rdCaptureResponse.getPidData();
            this.imageReceived(capturedImages);
        }
    }
}

