/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.confirm;

import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.bio.BiometricsIcons;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.event.AsyncAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

class ConfirmNonRDActions {
    private final AsyncAction startAxn;
    private final AsyncAction stopAxn;
    private final AsyncAction forceAxn;
    private final AsyncAction qssAxn;
    private final BiometricsNonRDField cfmField;

    ConfirmNonRDActions(BiometricsNonRDField cap) {
        this.cfmField = cap;
        new BiometricsIcons();
        this.startAxn = new AsyncAction().setName("Start Capture").setCommandKey("StartCapture").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_CAP_START_ICON")).setHandler(evt1 -> this.cfmField.doStartCapture());
        this.stopAxn = new AsyncAction().setName("Stop Capture").setCommandKey("StopCapture").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_CAP_STOP_ICON")).setHandler(evt1 -> this.cfmField.doEndCapture());
        this.forceAxn = new AsyncAction().setName("Force Capture").setCommandKey("ForceCapture").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_CAP_FORCE_ICON")).setHandler(evt1 -> this.cfmField.doForceCapture());
        this.qssAxn = new AsyncAction().setName("QSS Details").setCommandKey("QSSDetails").setSmallIcon(ImageIconCache.getInst().getIcon("KEY_QSS_ICON")).setHandler(this.cfmField::doQSSActionPerformed);
        InputMap ipMap = this.cfmField.getInputMap(1);
        ActionMap axnMap = this.cfmField.getActionMap();
        ipMap.put(KeyStroke.getKeyStroke("SPACE"), "start");
        axnMap.put("start", this.startAxn);
        ipMap.put(KeyStroke.getKeyStroke("ENTER"), "force");
        axnMap.put("force", this.forceAxn);
        ipMap.put(KeyStroke.getKeyStroke("control Q"), "qss");
        axnMap.put("qss", this.qssAxn);
    }

    protected Action getStartAction() {
        return this.startAxn;
    }

    protected Action getStopAction() {
        return this.stopAxn;
    }

    protected Action getForceAction() {
        return this.forceAxn;
    }

    protected Action getQSSAction() {
        return this.qssAxn;
    }
}

