/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.confirm;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.biometrics.lvs.LVSPolicy;
import in.gov.uidai.lvs.model.RegistrationResult;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.bio.confirm.IConfirmPositions;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfirmPositions
implements IConfirmPositions {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfirmPositions.class);
    private final List<BiometricPosition> availPosList = new ArrayList<BiometricPosition>();
    private BiometricPosition lastPos;

    public DefaultConfirmPositions(String uid, LVSPolicy policy) {
        try {
            RegistrationResult regres = LVSLocator.instance().getRegistrationResult(uid);
            if (regres != null) {
                List poslist;
                List list = poslist = policy.equals((Object)LVSPolicy.PARTIAL) ? regres.getAllPositions() : regres.getVerifiedPositions();
                if (poslist != null) {
                    this.availPosList.addAll(poslist);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("unable to fetch from LVS", (Throwable)e);
        }
        this.lastPos = this.availPosList.isEmpty() ? BiometricPosition.UNKNOWN : this.availPosList.get(0);
    }

    public DefaultConfirmPositions(List<BiometricPosition> posList) {
        if (posList != null) {
            this.availPosList.addAll(posList);
        }
        if (!this.availPosList.isEmpty()) {
            this.lastPos = this.availPosList.get(0);
        }
    }

    @Override
    public List<BiometricPosition> getAvailable() {
        return this.availPosList;
    }

    @Override
    public BiometricPosition getLastUsed() {
        return this.lastPos;
    }

    @Override
    public void setLastUsed(BiometricPosition pos) {
        this.lastPos = pos;
    }
}

