/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.confirm;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.bio.confirm.IConfirmPositions;
import in.gov.uidai.swing.bio.confirm.PositionRenderer;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionSelector.class);
    private final JButton selBut;
    private final JPopupMenu bioPosPopup;
    private final DefaultListModel<BiometricPosition> listModel;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    public JList<BiometricPosition> bioPosList;
    private BiometricPosition bioPos;
    private DeviceType devType;
    private IConfirmPositions cnfPos;

    public PositionSelector() {
        this.listModel = new DefaultListModel();
        this.bioPosList = new JList<BiometricPosition>(this.listModel);
        this.bioPosList.setCellRenderer(new PositionRenderer());
        this.bioPosList.setVisibleRowCount(1);
        this.bioPosPopup = new JPopupMenu();
        this.bioPosPopup.setLayout(new BorderLayout());
        this.bioPosPopup.add((Component)new JScrollPane(this.bioPosList), "Center");
        this.selBut = new JButton(ImageIconCache.getInst().getIcon("KEY_CNF_POS_SEL_ICON"));
        this.selBut.setIconTextGap(5);
        this.selBut.setHorizontalTextPosition(2);
        this.selBut.setCursor(new Cursor(12));
        this.selBut.setContentAreaFilled(false);
        SingleLineBorder butBdr = new SingleLineBorder().dashInterval("1, 2").drawEdges(true, true, true, true).lineColor("#999999").lineThickness(1.0f);
        EmptyBorder emtBdr = new EmptyBorder(0, 5, 0, 0);
        this.selBut.setBorder(new CompoundBorder(butBdr, emtBdr));
        this.selBut.setFocusPainted(false);
        this.selBut.setFocusable(false);
        ActionListener butAxn = evt -> {
            if (!this.listModel.isEmpty()) {
                int y = this.selBut.getHeight();
                this.bioPosPopup.show(this.selBut, 0, y);
                this.bioPosList.grabFocus();
            }
        };
        this.selBut.addActionListener(butAxn);
        MouseAdapter listClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PositionSelector.this.updateWithListSelection();
                PositionSelector.this.bioPosPopup.setVisible(false);
            }
        };
        this.bioPosList.addMouseListener(listClick);
        AbstractAction listAxn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PositionSelector.this.updateWithListSelection();
                PositionSelector.this.bioPosPopup.setVisible(false);
            }
        };
        this.bioPosList.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.bioPosList.getActionMap().put("enter", listAxn);
        this.updateDeviceAndPos();
    }

    public void setConfirmPositions(IConfirmPositions cpos) {
        LOGGER.debug("setting confirm positions");
        this.cnfPos = cpos;
        this.listModel.removeAllElements();
        if (this.cnfPos != null) {
            List<BiometricPosition> posList = this.cnfPos.getAvailable();
            LOGGER.debug("received positions: ");
            LOGGER.debug("{}", posList);
            if (posList != null) {
                posList.forEach(this.listModel::addElement);
                this.bioPosList.setVisibleRowCount(Math.min(posList.size(), 8));
                if (posList.isEmpty()) {
                    this.selBut.setVisible(false);
                    this.bioPos = BiometricPosition.UNKNOWN;
                }
            }
        } else {
            this.selBut.setVisible(false);
            this.bioPos = BiometricPosition.UNKNOWN;
        }
        this.updateDeviceAndPos();
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.changeListeners.contains(cl)) {
            this.changeListeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.remove(cl);
    }

    public DeviceType getDeviceType() {
        return this.devType;
    }

    public BiometricPosition getBiometricPosition() {
        return this.bioPos;
    }

    public JButton getSelector() {
        return this.selBut;
    }

    private void updateDeviceAndPos() {
        this.bioPos = this.cnfPos == null || this.cnfPos.getAvailable().isEmpty() ? BiometricPosition.UNKNOWN : this.cnfPos.getLastUsed();
        switch (this.bioPos) {
            case FACE: {
                this.devType = DeviceType.PHOTO;
                break;
            }
            case LEFT_IRIS: 
            case RIGHT_IRIS: 
            case BOTH_IRIS: {
                this.devType = DeviceType.IRIS;
                break;
            }
            case LEFT_SLAP: 
            case RIGHT_SLAP: 
            case BOTH_THUMBS: 
            case LEFT_INDEX: 
            case LEFT_MIDDLE: 
            case LEFT_RING: 
            case LEFT_LITTLE: 
            case RIGHT_INDEX: 
            case RIGHT_MIDDLE: 
            case RIGHT_RING: 
            case RIGHT_LITTLE: 
            case ANY_FINGER: 
            case UNKNOWN: {
                this.devType = DeviceType.FINGERPRINT;
                break;
            }
            case PLACE_ANY_FINGER: {
                this.devType = DeviceType.FINGERPRINT_AUTH;
                break;
            }
            case CAPTURE_ANY_IRIS: {
                this.devType = DeviceType.IRIS_AUTH;
            }
        }
        this.selBut.setText(WordUtils.capitalizeFully((String)this.bioPos.name(), (char[])new char[]{'_'}).replace('_', ' '));
        this.changeListeners.forEach(cl -> cl.stateChanged(new ChangeEvent(this)));
    }

    private void updateWithListSelection() {
        if (this.cnfPos == null) {
            return;
        }
        BiometricPosition position = this.bioPosList.getSelectedValue();
        if (position != null) {
            this.cnfPos.setLastUsed(position);
        }
        this.updateDeviceAndPos();
    }

    public void setVisible(boolean flag) {
        this.bioPosPopup.setVisible(flag);
        this.bioPosList.setVisible(flag);
        this.selBut.setVisible(flag);
    }
}

