/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.player;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;

public class FrameScaler
extends ComponentAdapter {
    private double scaleFactor;
    private Dimension imgDim;
    private Point[] imgLocs;
    private final JComponent player;
    private AffineTransform aft;

    public FrameScaler(JComponent player) {
        this.resetScaleInfo();
        this.player = player;
        this.player.addComponentListener(this);
    }

    public synchronized void scale(Image[] sources) {
        if (this.scaleFactor > 0.01 && this.imgLocs != null) {
            return;
        }
        this.imgDim.width = sources[0].getWidth(this.player);
        this.imgDim.height = sources[0].getHeight(this.player);
        int width = this.player.getWidth();
        int height = this.player.getHeight();
        double widthRatio = (double)width * 1.0 / ((double)(this.imgDim.width * sources.length) * 1.0);
        double heightRatio = (double)height * 1.0 / ((double)this.imgDim.height * 1.0);
        this.scaleFactor = Math.min(widthRatio, heightRatio);
        double combWidth = (double)(this.imgDim.width * sources.length) * this.scaleFactor;
        double startx = (double)(width / 2) - combWidth / 2.0;
        this.imgLocs = new Point[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            this.imgLocs[i] = new Point();
            this.imgLocs[i].x = (int)(startx + combWidth / (double)sources.length * (double)i);
            this.imgLocs[i].y = height / 2 - (int)((double)this.imgDim.height * this.scaleFactor / 2.0);
        }
        if (this.imgDim.width < 0) {
            this.imgDim.width = 0;
        }
        if (this.imgDim.height < 0) {
            this.imgDim.height = 0;
        }
        this.aft = null;
    }

    public synchronized Point[] getDrawLocations() {
        return this.imgLocs;
    }

    public synchronized AffineTransform getAffineTransform() {
        if (this.aft == null) {
            this.aft = AffineTransform.getScaleInstance(this.scaleFactor, this.scaleFactor);
        }
        return this.aft;
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
        this.resetScaleInfo();
    }

    @Override
    public void componentResized(ComponentEvent evt) {
        this.resetScaleInfo();
    }

    @Override
    public void componentShown(ComponentEvent evt) {
        this.resetScaleInfo();
    }

    private synchronized void resetScaleInfo() {
        this.scaleFactor = 0.0;
        this.imgDim = new Dimension(0, 0);
        this.imgLocs = null;
    }
}

