/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.player;

import in.gov.uidai.ec.biometrics.device.VideoFrame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameToImageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameToImageConverter.class);
    private BufferedImage encFrmImg;
    private ImageReadParam encFrmIrp;

    public Image convert(VideoFrame frame) {
        if (frame == null) {
            return null;
        }
        byte[] data = frame.getData();
        if (ArrayUtils.isEmpty((byte[])data)) {
            return null;
        }
        if (StringUtils.isBlank((String)frame.getEncoding())) {
            return this.rawToImage(data, frame.getWidth(), frame.getHeight());
        }
        if (StringUtils.equalsIgnoreCase((String)frame.getEncoding(), (String)"jpeg2000") || StringUtils.equalsIgnoreCase((String)frame.getEncoding(), (String)"jpeg")) {
            try {
                return this.jpgToImage(data, frame.getWidth(), frame.getHeight());
            }
            catch (Exception exep) {
                LOGGER.error("Error converting jpg to image", (Throwable)exep);
                return null;
            }
        }
        if (StringUtils.equalsIgnoreCase((String)frame.getEncoding(), (String)"png")) {
            try {
                return this.pngToImage(data, frame.getWidth(), frame.getHeight());
            }
            catch (Exception exep) {
                LOGGER.error("Error converting png to image", (Throwable)exep);
                return null;
            }
        }
        return null;
    }

    private Image rawToImage(byte[] data, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 10);
        DataBuffer dataBuf = image.getRaster().getDataBuffer();
        for (int i = 0; i < data.length - 4; ++i) {
            int pix = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8;
            dataBuf.setElem(i, pix);
        }
        return image;
    }

    private Image jpgToImage(byte[] data, int width, int height) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
        ImageReader imgr = ImageIO.getImageReaders(iis).next();
        imgr.setInput(iis, true, true);
        if (this.encFrmImg == null) {
            GraphicsConfiguration gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.encFrmImg = gconf.createCompatibleImage(width / 2, height / 2);
            this.encFrmIrp = imgr.getDefaultReadParam();
            this.encFrmIrp.setDestination(this.encFrmImg);
            this.encFrmIrp.setSourceProgressivePasses(1, 1);
            this.encFrmIrp.setSourceSubsampling(2, 2, 0, 0);
        }
        imgr.read(0, this.encFrmIrp);
        imgr.dispose();
        return this.encFrmImg;
    }

    private Image pngToImage(byte[] data, int width, int height) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
        ImageReader imgr = ImageIO.getImageReaders(iis).next();
        imgr.setInput(iis, true, true);
        if (this.encFrmImg == null) {
            this.encFrmImg = new BufferedImage(width / 2, height / 2, 6);
            this.encFrmIrp = imgr.getDefaultReadParam();
            this.encFrmIrp.setDestination(this.encFrmImg);
            this.encFrmIrp.setSourceProgressivePasses(1, 1);
            this.encFrmIrp.setSourceSubsampling(2, 2, 0, 0);
        }
        imgr.read(0, this.encFrmIrp);
        imgr.dispose();
        return this.encFrmImg;
    }
}

