/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.player;

import in.gov.uidai.ec.biometrics.device.IFrameListener;
import in.gov.uidai.ec.biometrics.device.IGenericDeviceContext;
import in.gov.uidai.ec.biometrics.device.VideoFrame;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.border.DashedBorder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewPlayer
extends AbstractPreviewPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreviewPlayer.class);
    private static final String NOVIDEO_ICON_PATH = "res/images/no-video.png";
    private static Image noInputImg;
    private Image currentFrame;
    private double scale;
    private int imgWidth;
    private int imgHeight;
    private int drawPosX;
    private int drawPosY;

    public PreviewPlayer() {
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setDoubleBuffered(true);
        this.setBorder(new DashedBorder().dashInterval("10, 5").lineColor("#cccccc").lineThickness(2.0f));
        ComponentAdapter compad = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                PreviewPlayer.this.resetScaleInfo();
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                PreviewPlayer.this.resetScaleInfo();
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                PreviewPlayer.this.resetScaleInfo();
            }
        };
        this.addComponentListener(compad);
    }

    @Override
    public void startPreview(IGenericDeviceContext devCtxt) {
        IFrameListener frml = new IFrameListener(){

            public void frameReceived(VideoFrame[] frames) {
                PreviewPlayer.this.doFrameReceived(frames);
            }
        };
        devCtxt.addFrameListener(frml);
    }

    @Override
    public void endPreview(IGenericDeviceContext devCtxt) {
        this.currentFrame = null;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentFrame == null) {
            int posx = this.getWidth() / 2 - noInputImg.getWidth(this) / 2;
            int posy = this.getHeight() / 2 - noInputImg.getHeight(this) / 2;
            g.drawImage(noInputImg, posx, posy, this);
        } else {
            g.drawImage(this.currentFrame, this.drawPosX, this.drawPosY, this);
        }
    }

    private void doFrameReceived(VideoFrame[] frames) {
        if (frames == null || frames.length == 0) {
            this.currentFrame = null;
            this.repaint();
            return;
        }
        byte[] data = frames[0].getData();
        if (ArrayUtils.isEmpty((byte[])data)) {
            this.currentFrame = null;
            this.repaint();
            return;
        }
        if (StringUtils.isBlank((String)frames[0].getEncoding())) {
            BufferedImage image = new BufferedImage(frames[0].getWidth(), frames[0].getHeight(), 10);
            DataBuffer dataBuf = image.getRaster().getDataBuffer();
            for (int i = 0; i < data.length - 4; ++i) {
                int pix = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8;
                dataBuf.setElem(i, pix);
            }
            this.resizeAndMakeCurrentImage(image);
        } else {
            try {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(data));
                this.resizeAndMakeCurrentImage(image);
            }
            catch (Exception exep) {
                this.currentFrame = null;
            }
        }
        this.repaint(5L);
    }

    private void resetScaleInfo() {
        this.scale = 0.0;
        this.imgWidth = 1;
        this.imgHeight = 1;
        this.drawPosX = -1;
        this.drawPosY = -1;
    }

    private void calculateScaleInfo(Image src) {
        if (this.scale > 0.01) {
            return;
        }
        this.imgWidth = src.getWidth(this);
        this.imgHeight = src.getHeight(this);
        int width = this.getWidth();
        int height = this.getHeight();
        double widthRatio = (double)width * 1.0 / ((double)this.imgWidth * 1.0);
        double heightRatio = (double)height * 1.0 / ((double)this.imgHeight * 1.0);
        this.scale = Math.min(widthRatio, heightRatio);
        this.drawPosX = width / 2 - (int)((double)this.imgWidth * this.scale / 2.0);
        this.drawPosY = height / 2 - (int)((double)this.imgHeight * this.scale / 2.0);
        if (this.drawPosX < 0) {
            this.drawPosX = 0;
        }
        if (this.drawPosY < 0) {
            this.drawPosY = 0;
        }
    }

    private void resizeAndMakeCurrentImage(Image src) {
        Image result;
        this.calculateScaleInfo(src);
        this.currentFrame = result = src.getScaledInstance((int)((double)this.imgWidth * this.scale), (int)((double)this.imgHeight * this.scale), 2);
    }

    static {
        try {
            ClassLoader cldr = Thread.currentThread().getContextClassLoader();
            if (cldr == null) {
                cldr = PreviewPlayer.class.getClassLoader();
            }
            InputStream noInputStrm = cldr.getResourceAsStream(NOVIDEO_ICON_PATH);
            noInputImg = ImageIO.read(noInputStrm);
        }
        catch (Exception exep) {
            LOGGER.error(exep.toString(), (Throwable)exep);
        }
    }
}

