/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.player;

import in.gov.uidai.ec.biometrics.device.IFrameListener;
import in.gov.uidai.ec.biometrics.device.IGenericDeviceContext;
import in.gov.uidai.ec.biometrics.device.VideoFrame;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.bio.player.FrameScaler;
import in.gov.uidai.swing.bio.player.FrameToImageConverter;
import in.gov.uidai.swing.bio.player.PreviewPlayer;
import in.gov.uidai.swing.border.DashedBorder;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewPlayer2
extends AbstractPreviewPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreviewPlayer2.class);
    private static final String NOVIDEO_ICON_PATH = "res/images/no-video.png";
    private static final String TIP_FORCE = "Capture now!";
    private static final String TIP_STOP = "Click to stop capture";
    private static Image noInputImg;
    private LinkedBlockingDeque<Image[]> frmBuf;
    private Timer frmTimer;
    private FrameToImageConverter converter;
    private FrameScaler scaler;
    private IFrameListener frml;
    private Image[] currentImages;
    private boolean videoStarted;

    public PreviewPlayer2() {
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setDoubleBuffered(true);
        this.setBorder(new DashedBorder().dashInterval("10, 5").lineColor("#cccccc").lineThickness(2.0f));
        this.frmBuf = new LinkedBlockingDeque(5);
        this.converter = new FrameToImageConverter();
        this.scaler = new FrameScaler(this);
        ActionListener trigger = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreviewPlayer2.this.animate();
            }
        };
        this.frmTimer = new Timer(40, trigger);
        this.frmTimer.setRepeats(true);
        this.frmTimer.setCoalesce(true);
        this.frml = new IFrameListener(){

            public void frameReceived(VideoFrame[] frames) {
                PreviewPlayer2.this.doFrameReceived(frames);
            }
        };
    }

    @Override
    public void startPreview(IGenericDeviceContext dc) {
        this.videoRestarted();
        this.converter = new FrameToImageConverter();
        this.frmBuf = new LinkedBlockingDeque(5);
        dc.addFrameListener(this.frml);
        this.currentImages = null;
        this.frmTimer.restart();
    }

    @Override
    public void endPreview(IGenericDeviceContext dc) {
        if (dc != null) {
            dc.removeFrameListener(this.frml);
        }
        this.frmTimer.stop();
        this.frmBuf = null;
        this.converter = null;
        this.currentImages = null;
        this.videoRestarted();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentImages != null && this.currentImages.length > 0) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.scaler.scale(this.currentImages);
            Point[] drawLocs = this.scaler.getDrawLocations();
            if (drawLocs == null || drawLocs.length != this.currentImages.length) {
                return;
            }
            int i = 0;
            int j = this.currentImages.length - 1;
            while (i < this.currentImages.length) {
                g.translate(drawLocs[i].x, drawLocs[i].y);
                ((Graphics2D)g).drawImage(this.currentImages[j], this.scaler.getAffineTransform(), this);
                g.translate(-drawLocs[i].x, -drawLocs[i].y);
                ++i;
                --j;
            }
        } else {
            int posx = this.getWidth() / 2 - noInputImg.getWidth(this) / 2;
            int posy = this.getHeight() / 2 - noInputImg.getHeight(this) / 2;
            g.drawImage(noInputImg, posx, posy, this);
        }
    }

    private void doFrameReceived(VideoFrame[] frames) {
        this.firstFrameReceived();
        try {
            int i;
            Image[] images = new Image[frames.length];
            for (i = 0; i < images.length; ++i) {
                images[i] = this.converter.convert(frames[i]);
            }
            for (i = 0; i < 5 && !this.frmBuf.offerLast(images, 200L, TimeUnit.MILLISECONDS); ++i) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void animate() {
        if (this.frmBuf == null) {
            return;
        }
        Image[] nextImages = this.frmBuf.pollFirst();
        if (nextImages != null) {
            this.currentImages = nextImages;
            this.repaint();
        }
    }

    private void videoRestarted() {
        this.videoStarted = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setEnabled(false);
        this.setToolTipText(null);
    }

    private void firstFrameReceived() {
        if (this.videoStarted) {
            return;
        }
        this.videoStarted = true;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setEnabled(true);
        if (this.isForcedCaptureAllowed()) {
            this.setToolTipText(TIP_FORCE);
        } else {
            this.setToolTipText(TIP_STOP);
        }
    }

    static {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = PreviewPlayer.class.getClassLoader();
            }
            InputStream noInputStrm = cl.getResourceAsStream(NOVIDEO_ICON_PATH);
            noInputImg = ImageIO.read(noInputStrm);
        }
        catch (Exception exep) {
            LOGGER.error(exep.getMessage(), (Throwable)exep);
        }
    }
}

