/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.thumb;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.service.enrollment.CapturedImageConverter;
import in.gov.uidai.swing.bio.thumb.ThumbOverlay;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class CaptureThumbnail
extends JComponent {
    private static final Color DISABLED_COLOR = new Color(16, 16, 16, 200);
    private CapturedImage capturedImage;
    private Image srcImage;
    private Image tempImage;
    private boolean autoCrop;
    private Color disabledColor;
    private Map<String, ThumbOverlay> ovlMap = new HashMap<String, ThumbOverlay>();

    public CaptureThumbnail() {
        ComponentAdapter adapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                CaptureThumbnail.this.tempSizeImage();
                CaptureThumbnail.this.srcImage = null;
                CaptureThumbnail.this.repaint();
            }
        };
        this.addComponentListener(adapter);
    }

    public void setAutoCrop(boolean flag) {
        this.autoCrop = flag;
    }

    public void setDisabledColor(Color col) {
        this.disabledColor = col;
    }

    public void setThumbnailImage(CapturedImage img) {
        Runnable runnable = () -> {
            this.capturedImage = img;
            this.tempSizeImage();
            this.srcImage = null;
            this.repaint();
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addOverlay(ThumbOverlay ovl) {
        this.ovlMap.clear();
        if (ovl != null) {
            this.ovlMap.put(ovl.getName(), ovl);
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Point pt;
        Color col = this.getBackground();
        if (!this.isEnabled()) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (col != null && this.isOpaque()) {
            g.setColor(col);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.reloadImage();
        if (this.tempImage != null) {
            pt = this.getDrawOrigin(true);
            g.drawImage(this.tempImage, pt.x, pt.y, this);
        } else if (this.srcImage != null) {
            pt = this.getDrawOrigin(false);
            g.drawImage(this.srcImage, pt.x, pt.y, this);
        }
        if (!this.isEnabled()) {
            if (this.disabledColor == null) {
                g.setColor(DISABLED_COLOR);
            } else {
                g.setColor(this.disabledColor);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        for (ThumbOverlay thumbOverlay : this.ovlMap.values()) {
            thumbOverlay.paintOverlay(this, g);
        }
    }

    private void reloadImage() {
        if (this.capturedImage == null || this.srcImage != null) {
            return;
        }
        Runnable runnable = () -> {
            this.srcImage = CapturedImageConverter.toRenderableImage((CapturedImage)this.capturedImage, (JComponent)this, (boolean)this.autoCrop);
            this.tempImage = null;
            this.repaint();
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void tempSizeImage() {
        if (this.capturedImage == null) {
            return;
        }
        if (this.tempImage == null && this.srcImage != null) {
            this.tempImage = CapturedImageConverter.toTemporaryImage((Image)this.srcImage, (JComponent)this);
        }
    }

    private Point getDrawOrigin(boolean temp) {
        Image img;
        Point result = new Point();
        Image image = img = temp ? this.tempImage : this.srcImage;
        if (img == null) {
            return result;
        }
        result.x = this.getWidth() / 2 - img.getWidth(this) / 2;
        result.y = this.getHeight() / 2 - img.getHeight(this) / 2;
        if (result.x < 0) {
            result.x = 0;
        }
        if (result.y < 0) {
            result.y = 0;
        }
        return result;
    }
}

