/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.thumb;

import in.gov.uidai.swing.ImageIconCache;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;

public class ThumbOverlay {
    private String name;
    private Image ovlImg;
    private int offsetX;
    private int offsetY;
    private int originValue;
    private boolean visible;

    public ThumbOverlay(String name) {
        this.name = name;
        this.visible = true;
    }

    public ThumbOverlay image(Image img) {
        this.ovlImg = img;
        return this;
    }

    public ThumbOverlay image(String iconName) {
        try {
            ImageIcon ovlIcon = ImageIconCache.getInst().getIcon(iconName);
            this.ovlImg = ovlIcon.getImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public ThumbOverlay offset(int offx, int offy) {
        this.offsetX = offx;
        this.offsetY = offy;
        return this;
    }

    public ThumbOverlay origin(int origin) {
        switch (origin) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                this.originValue = origin;
                break;
            }
            default: {
                this.originValue = 0;
            }
        }
        return this;
    }

    public ThumbOverlay visible(boolean flag) {
        this.visible = flag;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void paintOverlay(Component comp, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.ovlImg == null) {
            return;
        }
        int width = this.ovlImg.getWidth(comp);
        int height = this.ovlImg.getHeight(comp);
        int posx = 0;
        int posy = 0;
        switch (this.originValue) {
            case 2: {
                posx = comp.getWidth() - width - this.offsetX;
                posy = this.offsetY;
                break;
            }
            case 8: {
                posx = this.offsetX;
                posy = this.offsetY;
                break;
            }
            case 4: {
                posx = comp.getWidth() - width - this.offsetX;
                posy = comp.getHeight() - height - this.offsetY;
                break;
            }
            case 6: {
                posx = this.offsetX;
                posy = comp.getHeight() - height - this.offsetY;
                break;
            }
            default: {
                posx = comp.getWidth() / 2 - width / 2;
                posy = comp.getHeight() / 2 - height / 2;
            }
        }
        g.drawImage(this.ovlImg, posx, posy, comp);
    }
}

