/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.bio.view;

import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.ViewElement;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import org.apache.commons.lang.StringUtils;

public class BiometricsCaptureElement
extends ViewElement {
    public static final String KEY_ALL_ATTEMPTS = "allAttempts";
    public static final String KEY_BEST_ATTEMPT = "bestAttempt";
    public static final String KEY_CURRENT_ATTEMPT = "currentAttempt";
    public static final String KEY_ALL_ATTEMPTS_MULTIPOS = "allAttemptsMultiPos";
    public static final String KEY_BEST_ATTEMPT_MULTIPOS = "bestAttemptMultiPos";
    public static final String KEY_CURRENT_ATTEMPT_MULTIPOS = "currentAttemptMultiPos";
    public static final String KEY_QUALITY_PASS = "qualityPass";
    public static final String KEY_DELETE = "delete";
    public static final String AXN_STOP_CAPTURE = "stopCapture";
    public static final String AXN_CLEAR = "clear";
    private final BiometricsCaptureField theComp;

    protected BiometricsCaptureElement(BiometricsCaptureField comp, String name) {
        super(comp, name);
        this.theComp = comp;
    }

    @Override
    public Object get(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        if (key.equalsIgnoreCase(KEY_ALL_ATTEMPTS)) {
            return this.theComp.getCaptureAttempts();
        }
        if (key.equalsIgnoreCase(KEY_BEST_ATTEMPT)) {
            return this.theComp.getBestAttempt();
        }
        if (key.equalsIgnoreCase(KEY_CURRENT_ATTEMPT)) {
            return this.theComp.getCurrentAttempt();
        }
        if (key.equalsIgnoreCase(KEY_QUALITY_PASS)) {
            return this.theComp.isQualityPassed();
        }
        if (key.equalsIgnoreCase(KEY_ALL_ATTEMPTS_MULTIPOS)) {
            return this.theComp.getAllCaptureAttempts();
        }
        if (key.equalsIgnoreCase(KEY_BEST_ATTEMPT_MULTIPOS)) {
            return this.theComp.getAllBestAttempts();
        }
        if (key.equalsIgnoreCase(KEY_CURRENT_ATTEMPT_MULTIPOS)) {
            return this.theComp.getAllCurrentAttempts();
        }
        return super.get(key);
    }

    @Override
    public IViewElement mset(String key, Object ... values) {
        if (StringUtils.isBlank((String)key)) {
            return this;
        }
        if (StringUtils.equalsIgnoreCase((String)key, (String)KEY_DELETE)) {
            if (values != null) {
                for (Object value : values) {
                    if (value == null) continue;
                    this.theComp.delete(value.toString());
                }
            }
            return this;
        }
        return super.mset(key, values);
    }

    @Override
    public IViewElement call(String action) {
        if (StringUtils.isBlank((String)action)) {
            return this;
        }
        if (action.equalsIgnoreCase(AXN_STOP_CAPTURE)) {
            this.theComp.stopCapture();
            return this;
        }
        if (action.equalsIgnoreCase(AXN_CLEAR)) {
            this.theComp.clear();
            return this;
        }
        return super.call(action);
    }
}

