/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

public class DashedBorder
implements Border {
    private Color lineCol;
    private float thickness;
    private float[] dashIntervals;

    public DashedBorder lineColor(String colHex) {
        this.lineCol = Color.decode(colHex);
        return this;
    }

    public DashedBorder lineColor(Color col) {
        this.lineCol = col;
        return this;
    }

    public DashedBorder lineThickness(float thickness) {
        this.thickness = thickness;
        return this;
    }

    public DashedBorder dashInterval(String spec) {
        String[] dashes = spec.split(",");
        this.dashIntervals = new float[dashes.length];
        for (int i = 0; i < this.dashIntervals.length; ++i) {
            this.dashIntervals[i] = Float.parseFloat(dashes[i].trim());
        }
        return this;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        int gap = Math.round(this.thickness) + 1;
        return new Insets(gap, gap, gap, gap);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(x, y);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldCol = g2.getColor();
        g2.setColor(this.lineCol);
        g2.setStroke(new BasicStroke(this.thickness, 0, 0, this.thickness, this.dashIntervals, 0.0f));
        g2.drawRect(Math.round(this.thickness) / 2, Math.round(this.thickness) / 2, width - Math.round(this.thickness), height - Math.round(this.thickness));
        g2.setColor(oldCol);
        g2.translate(-x, -y);
    }
}

