/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

public class RoundedBorder
implements Border {
    private Color lineCol;
    private float thickness;
    private int roundWidth;
    private int roundHeight;

    public RoundedBorder lineColor(String colHex) {
        this.lineCol = Color.decode(colHex);
        return this;
    }

    public RoundedBorder lineColor(Color col) {
        this.lineCol = col;
        return this;
    }

    public RoundedBorder lineThickness(float thickness) {
        this.thickness = thickness;
        return this;
    }

    public RoundedBorder rounding(int width, int height) {
        this.roundHeight = height;
        this.roundWidth = width;
        return this;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return new Insets(this.roundHeight, this.roundWidth, this.roundHeight, this.roundWidth);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(x, y);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldCol = g2.getColor();
        g2.setColor(this.lineCol);
        g2.setStroke(new BasicStroke(this.thickness, 0, 0, this.thickness));
        g2.drawRoundRect(Math.round(this.thickness) / 2, Math.round(this.thickness) / 2, width - Math.round(this.thickness), height - Math.round(this.thickness), this.roundWidth * 2, this.roundHeight * 2);
        g2.translate(-x, -y);
        g2.setColor(oldCol);
    }
}

