/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

public class SingleLineBorder
implements Border {
    private Color lineCol;
    private boolean northFlag;
    private boolean westFlag;
    private boolean southFlag;
    private boolean eastFlag;
    private float thickness = 1.0f;
    private float[] dashIntervals;

    public SingleLineBorder lineColor(String colHex) {
        this.lineCol = Color.decode(colHex);
        return this;
    }

    public SingleLineBorder lineColor(Color col) {
        this.lineCol = col;
        return this;
    }

    public SingleLineBorder lineThickness(float thickness) {
        this.thickness = thickness;
        return this;
    }

    public SingleLineBorder dashInterval(String spec) {
        String[] dashes = spec.split(",");
        this.dashIntervals = new float[dashes.length];
        for (int i = 0; i < this.dashIntervals.length; ++i) {
            this.dashIntervals[i] = Float.parseFloat(dashes[i].trim());
        }
        return this;
    }

    public SingleLineBorder drawEdges(boolean north, boolean west, boolean south, boolean east) {
        this.northFlag = north;
        this.westFlag = west;
        this.southFlag = south;
        this.eastFlag = east;
        return this;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        int gap = Math.round(this.thickness) + 1;
        return new Insets(gap, gap, gap, gap);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(x, y);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldCol = g2.getColor();
        if (this.dashIntervals == null || this.dashIntervals.length == 0) {
            g2.setStroke(new BasicStroke(this.thickness, 0, 0, this.thickness));
        } else {
            g2.setStroke(new BasicStroke(this.thickness, 0, 0, this.thickness, this.dashIntervals, 0.0f));
        }
        g2.setColor(this.lineCol);
        if (this.southFlag) {
            g2.drawLine(0, height - Math.round(this.thickness), width, height - Math.round(this.thickness));
        }
        if (this.northFlag) {
            g2.drawLine(0, 0, width, 0);
        }
        if (this.westFlag) {
            g2.drawLine(0, 0, 0, height);
        }
        if (this.eastFlag) {
            g2.drawLine(width - Math.round(this.thickness), 0, width - Math.round(this.thickness), height);
        }
        g2.translate(-x, -y);
        g2.setColor(oldCol);
    }
}

