/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.border;

import in.gov.uidai.swing.border.UndecoratedRootPaneBorder;
import in.gov.uidai.swing.fontman.FontManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndecoratedRootPaneBorderWhite
implements Border {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndecoratedRootPaneBorder.class);
    private Insets insets = new Insets(50, 5, 5, 5);
    private JLabel renderer = new JLabel();

    public UndecoratedRootPaneBorderWhite() {
        this.renderer.setHorizontalTextPosition(2);
        this.renderer.setHorizontalAlignment(4);
        this.renderer.setVerticalAlignment(0);
        this.renderer.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.renderer.setForeground(Color.WHITE);
    }

    public void setTitleFont(String path, int style, int size) {
        try {
            this.renderer.setFont(FontManager.getInst().getScreenFont(path, style, size));
        }
        catch (Throwable th) {
            LOGGER.error("Error setting Title Font", th);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        String title;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.WHITE);
        BasicStroke stroke = new BasicStroke(2.0f);
        g2.setStroke(stroke);
        g2.drawRect(x, y, width, height);
        g2.drawRect(x + 1, y + 1, width - 2, height - 2);
        g2.fillRect(x, y, width, 40);
        Window win = SwingUtilities.getWindowAncestor(c);
        if (win instanceof Dialog) {
            title = ((Dialog)win).getTitle();
            this.renderer.setText(title);
        } else if (win instanceof Frame) {
            title = ((Frame)win).getTitle();
            this.renderer.setText(title);
        }
        List<Image> iconList = ((Dialog)win).getIconImages();
        if (!iconList.isEmpty()) {
            Image icon = iconList.get(0).getScaledInstance(32, 32, 4);
            this.renderer.setIcon(new ImageIcon(icon));
        } else {
            this.renderer.setIcon(null);
        }
        this.renderer.setSize(width, 40);
        this.renderer.paint(g2);
    }
}

