/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.combo;

import in.gov.uidai.swing.combo.DropDownItem;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;

public class PropertiesComboModel
extends DefaultComboBoxModel {
    public PropertiesComboModel() {
    }

    public PropertiesComboModel(String path) {
        this.update(path);
    }

    public void update(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Properties props = new Properties();
        try {
            InputStream input = cl.getResourceAsStream(path);
            props.load(input);
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doLoad(props);
    }

    public void update(Properties props) {
        this.doLoad(props);
    }

    public void setFirstOption(String key, String value) {
        this.insertElementAt(new DropDownItem(key, value), 0);
    }

    private void doLoad(Properties props) {
        this.removeAllElements();
        ArrayList<DropDownItem> ddiList = new ArrayList<DropDownItem>();
        for (String key : props.stringPropertyNames()) {
            ddiList.add(new DropDownItem(key, props.getProperty(key)));
        }
        Collections.sort(ddiList);
        for (DropDownItem ddi : ddiList) {
            this.addElement(ddi);
        }
    }
}

