/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.date;

import in.gov.uidai.swing.TransparentBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarBox
extends TransparentBox {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarBox.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("MMM yyyy");
    private JButton prevBut;
    private JButton nextBut;
    private JLabel titleField;
    private JLabel[][] dayCells;
    private TransparentBox[] dayRows;
    private TransparentBox navPanel;
    private TransparentBox datePanel;
    private GregorianCalendar selectedDate = new GregorianCalendar();
    private GregorianCalendar yearMonth = new GregorianCalendar();

    public CalendarBox() {
        this.datePanel = new TransparentBox();
        BoxLayout boxl = new BoxLayout(this.datePanel, 1);
        this.datePanel.setLayout(boxl);
        this.datePanel.setBackground(Color.decode("#f5f5b5"));
        this.datePanel.setOpaque(true);
        TransparentBox headers = new TransparentBox(new GridLayout(1, 7, 1, 1));
        headers.add(this.createTitleLabel("Su"));
        headers.add(this.createTitleLabel("Mo"));
        headers.add(this.createTitleLabel("Tu"));
        headers.add(this.createTitleLabel("We"));
        headers.add(this.createTitleLabel("Th"));
        headers.add(this.createTitleLabel("Fr"));
        headers.add(this.createTitleLabel("Sa"));
        this.datePanel.add(headers);
        MouseAdapter dayMouse = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CalendarBox.this.onMouseClick(evt);
            }
        };
        this.dayCells = new JLabel[6][7];
        this.dayRows = new TransparentBox[6];
        for (int i = 0; i < 6; ++i) {
            this.dayRows[i] = new TransparentBox(new GridLayout(1, 7, 1, 1));
            this.dayRows[i].setBorder(new EmptyBorder(1, 0, 0, 0));
            this.datePanel.add(this.dayRows[i]);
            for (int j = 0; j < 7; ++j) {
                this.dayCells[i][j] = this.createDayCell();
                this.dayCells[i][j].addMouseListener(dayMouse);
                this.dayRows[i].add(this.dayCells[i][j]);
            }
        }
        this.navPanel = new TransparentBox(new BorderLayout(3, 3));
        this.titleField = new JLabel();
        this.prevBut = new JButton("<");
        ActionListener prevx = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarBox.this.shiftMonth(-1);
            }
        };
        this.prevBut.addActionListener(prevx);
        this.nextBut = new JButton(">");
        ActionListener nextx = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarBox.this.shiftMonth(1);
            }
        };
        this.nextBut.addActionListener(nextx);
        this.navPanel.add((Component)this.titleField, "Center");
        this.navPanel.add((Component)this.prevBut, "West");
        this.navPanel.add((Component)this.nextBut, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.navPanel, "North");
        this.add((Component)this.datePanel, "Center");
    }

    public void setSelectedDate(Date date) {
        this.selectedDate.setTime(date);
        this.yearMonth.setTime(date);
        this.updateForYearMonth();
    }

    public Date getSelectedDate() {
        return this.selectedDate.getTime();
    }

    private JLabel createDayCell() {
        JLabel result = new JLabel();
        result.setOpaque(true);
        result.setBackground(Color.WHITE);
        result.setHorizontalAlignment(0);
        result.setFont(result.getFont().deriveFont(1));
        result.setPreferredSize(new Dimension(27, 18));
        return result;
    }

    private JLabel createTitleLabel(String text) {
        JLabel result = new JLabel(text);
        result.setOpaque(false);
        result.setHorizontalAlignment(0);
        result.setFont(result.getFont().deriveFont(1));
        result.setPreferredSize(new Dimension(27, 18));
        return result;
    }

    private void updateForYearMonth() {
        try {
            this.titleField.setText(SDF.format(this.yearMonth.getTime()));
        }
        catch (Exception exep) {
            LOGGER.error("CalendarBox error updating title for year-month", (Throwable)exep);
        }
        GregorianCalendar cal = new GregorianCalendar();
        int todYear = cal.get(1);
        int todMonth = cal.get(2);
        int today = cal.get(5);
        cal.setTime(this.yearMonth.getTime());
        int maxDay = cal.getActualMaximum(5);
        cal.set(5, 1);
        int dow = cal.get(7);
        for (int i = 0; i < 6; ++i) {
            this.dayRows[i].setVisible(false);
        }
        int dayCount = 1;
        int cellCount = 1;
        for (int i = 0; i < 6; ++i) {
            if (dayCount < maxDay) {
                this.dayRows[i].setVisible(true);
            }
            for (int j = 0; j < 7; ++j) {
                if (dow > cellCount) {
                    this.resetDayCell(i, j);
                    ++cellCount;
                    continue;
                }
                if (dayCount > maxDay) {
                    this.resetDayCell(i, j);
                    continue;
                }
                this.setDayCell(i, j, dayCount);
                if (todYear == this.yearMonth.get(1) && todMonth == this.yearMonth.get(2) && today == dayCount) {
                    this.highlightDayCell(i, j, Color.RED, Color.WHITE);
                }
                ++dayCount;
            }
        }
        JPopupMenu popup = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, this);
        if (popup != null) {
            popup.pack();
            popup.validate();
        }
    }

    private void resetDayCell(int row, int col) {
        this.dayCells[row][col].setOpaque(true);
        this.dayCells[row][col].setText(null);
        this.dayCells[row][col].setVisible(false);
    }

    private void setDayCell(int row, int col, int value) {
        this.dayCells[row][col].setVisible(true);
        this.dayCells[row][col].setOpaque(true);
        this.dayCells[row][col].setText(Integer.toString(value));
    }

    private void highlightDayCell(int row, int col, Color bgcol, Color fgcol) {
        this.dayCells[row][col].setBackground(bgcol);
        this.dayCells[row][col].setForeground(fgcol);
    }

    private void shiftMonth(int amount) {
        this.yearMonth.add(2, amount);
        this.updateForYearMonth();
    }

    private void onMouseClick(MouseEvent evt) {
        JLabel dayCell = (JLabel)evt.getSource();
        if (dayCell == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)dayCell.getText())) {
            try {
                int day = Integer.parseInt(dayCell.getText());
                this.selectedDate.set(5, day);
                this.selectedDate.set(2, this.yearMonth.get(2));
                this.selectedDate.set(1, this.yearMonth.get(1));
            }
            catch (Exception day) {
                // empty catch block
            }
            JPopupMenu popup = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, this);
            if (popup != null) {
                popup.setVisible(false);
            }
        }
    }
}

