/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.date;

import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.ZeroAsEmptyMaskFormatter;
import in.gov.uidai.swing.date.CalendarBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class DateSelectField
extends JComponent {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("ddMMyyyy");
    public static final String BUT_DATE_SEL = "but-date-sel";
    private JFormattedTextField textField;
    private JButton popupBut;
    private JPopupMenu calPopup;
    private CalendarBox calBox;

    public DateSelectField() {
        MaskFormatter fmt1 = new MaskFormatter();
        ZeroAsEmptyMaskFormatter fmt2 = new ZeroAsEmptyMaskFormatter();
        fmt1.setPlaceholderCharacter('0');
        fmt2.setPlaceholderCharacter('0');
        fmt1.setValueContainsLiteralCharacters(false);
        fmt2.setValueContainsLiteralCharacters(false);
        try {
            fmt1.setMask("##/##/####");
            fmt2.setMask("##/##/####");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultFormatterFactory dff = new DefaultFormatterFactory(fmt1, fmt2, fmt1);
        this.textField = new JFormattedTextField(dff);
        this.textField.putClientProperty("watermark-text", "DD/MM/YYYY");
        this.calBox = new CalendarBox();
        this.calPopup = new JPopupMenu();
        PopupMenuListener pml = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                DateSelectField.this.calBox.setSelectedDate(DateSelectField.this.getDate());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                DateSelectField.this.setDate(DateSelectField.this.calBox.getSelectedDate());
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
        this.calPopup.addPopupMenuListener(pml);
        this.calPopup.setBorder(new LineBorder(Color.decode("#f5f5b5")));
        this.calPopup.setLayout(new BorderLayout());
        this.calPopup.add((Component)this.calBox, "Center");
        this.popupBut = new JButton();
        this.popupBut.setIcon(ImageIconCache.getInst().getIcon(BUT_DATE_SEL));
        this.popupBut.setBorder(null);
        this.popupBut.setBorderPainted(false);
        this.popupBut.setContentAreaFilled(false);
        ActionListener pax = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateSelectField.this.calPopup.show(DateSelectField.this.textField, 0, DateSelectField.this.textField.getHeight());
            }
        };
        this.popupBut.addActionListener(pax);
        super.setLayout(new BorderLayout(2, 2));
        super.addImpl(this.textField, "Center", 0);
        super.addImpl(this.popupBut, "East", 1);
    }

    public Date getDate() {
        String value = (String)this.textField.getValue();
        try {
            return SDF.parse(value);
        }
        catch (Exception exep) {
            return new Date();
        }
    }

    public void setDate(Date date) {
        try {
            this.textField.setValue(SDF.format(date));
        }
        catch (Exception exep) {
            this.textField.setValue(SDF.format(new Date()));
        }
    }

    public JFormattedTextField getTextField() {
        return this.textField;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    static {
        ImageIconCache.getInst().addIcon(BUT_DATE_SEL, "res/cui/images/but-date.png");
    }
}

