/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.fontman;

import in.gov.uidai.swing.fontman.FontDetails;
import in.gov.uidai.swing.fontman.FontMeta;
import in.gov.uidai.swing.fontman.FontMetaList;
import in.gov.uidai.swing.fontman.FontStyles;
import in.gov.uidai.swing.fontman.Usage;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXB;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontManager.class);
    private static final String FONT_PATH = "./fonts";
    private static final String FONT_LIST_FILE = "font-list.xml";
    private static final FontManager theInst = new FontManager();
    private final Map<String, Font> scrnFileToFontMap = new HashMap<String, Font>();
    private final Map<String, Font> prnFileToFontMap = new HashMap<String, Font>();
    private final Map<FontDetails, Font> detailsToFontMap = new HashMap<FontDetails, Font>();
    private final List<FontMeta> scrnFontList = new ArrayList<FontMeta>();
    private final List<FontMeta> prnFontList = new ArrayList<FontMeta>();

    public static FontManager getInst() {
        return theInst;
    }

    private FontManager() {
        this.loadFontList();
        FilenameFilter fff = (dir, name) -> name.toLowerCase().endsWith(".ttf");
        File[] fontFiles = new File(FONT_PATH).listFiles(fff);
        if (fontFiles == null || fontFiles.length == 0) {
            return;
        }
        for (File ff : fontFiles) {
            this.loadFont(ff);
        }
    }

    public Font getScreenFont(String name, int style, int size) {
        return this.getFont(name, style, size, Usage.SCREEN);
    }

    public Font getPrintFont(String name, int style, int size) {
        return this.getFont(name, style, size, Usage.PRINT);
    }

    public Font getScreenFontForLocale(String localeStr) {
        return this.getScreenFontForLocale(localeStr, 0, 0);
    }

    public Font getPrintFontForLocale(String localeStr) {
        return this.getPrintFontForLocale(localeStr, 0, 0);
    }

    public Font getScreenFontForLocale(String localeStr, int style, int size) {
        return this.getFontForLocale(localeStr, style, size, Usage.SCREEN);
    }

    public Font getPrintFontForLocale(String localeStr, int style, int size) {
        return this.getFontForLocale(localeStr, style, size, Usage.PRINT);
    }

    public Font getScreenFontForLocale(Locale locale) {
        return this.getScreenFontForLocale(locale.toString());
    }

    private void loadFontList() {
        File fontListFile = new File(FONT_PATH, FONT_LIST_FILE);
        FontMetaList root = (FontMetaList)JAXB.unmarshal((File)fontListFile, FontMetaList.class);
        List<FontMeta> metaList = root.getFontMetaList();
        for (FontMeta meta : metaList) {
            if (meta.getUsageEnumerated() == null) continue;
            if (meta.getUsageEnumerated().equals((Object)Usage.SCREEN)) {
                this.scrnFontList.add(meta);
                continue;
            }
            if (!meta.getUsageEnumerated().equals((Object)Usage.PRINT)) continue;
            this.prnFontList.add(meta);
        }
    }

    private void loadFont(File ff) {
        FontMeta prnMeta;
        Font font = null;
        try {
            font = Font.createFont(0, ff);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
        }
        catch (Exception e) {
            LOGGER.error("Error loading font", (Throwable)e);
        }
        FontMeta scrnMeta = this.getFontMeta(ff, Usage.SCREEN);
        if (scrnMeta != null) {
            float size = scrnMeta.getSize();
            font = font.deriveFont(size);
            font = scrnMeta.applyStyle(font);
            this.scrnFileToFontMap.put(ff.getName().toLowerCase(), font);
        }
        if ((prnMeta = this.getFontMeta(ff, Usage.PRINT)) != null) {
            float size = prnMeta.getSize();
            font = font.deriveFont(size);
            font = prnMeta.applyStyle(font);
            this.prnFileToFontMap.put(ff.getName().toLowerCase(), font);
        }
    }

    private FontMeta getFontMeta(File ff, Usage usage) {
        block4: {
            block3: {
                if (usage == null) {
                    return null;
                }
                if (!usage.equals((Object)Usage.SCREEN)) break block3;
                for (FontMeta meta : this.scrnFontList) {
                    if (!StringUtils.equalsIgnoreCase((String)ff.getName().trim(), (String)meta.getFileName().trim())) continue;
                    return meta;
                }
                break block4;
            }
            if (!usage.equals((Object)Usage.PRINT)) break block4;
            for (FontMeta meta : this.prnFontList) {
                if (!StringUtils.equalsIgnoreCase((String)ff.getName(), (String)meta.getFileName())) continue;
                return meta;
            }
        }
        return null;
    }

    private FontMeta getFontMeta(String locale, Usage usage) {
        block4: {
            block3: {
                if (usage == null) {
                    return null;
                }
                if (!usage.equals((Object)Usage.SCREEN)) break block3;
                for (FontMeta meta : this.scrnFontList) {
                    if (!StringUtils.equalsIgnoreCase((String)locale, (String)meta.getLocale())) continue;
                    return meta;
                }
                break block4;
            }
            if (!usage.equals((Object)Usage.PRINT)) break block4;
            for (FontMeta meta : this.prnFontList) {
                if (!StringUtils.equalsIgnoreCase((String)locale, (String)meta.getLocale())) continue;
                return meta;
            }
        }
        return null;
    }

    private Font getFont(String name, int style, int size, Usage usage) {
        if (usage == null) {
            return null;
        }
        String lname = name.trim().toLowerCase();
        FontDetails fnDet = new FontDetails(lname, style, size, usage);
        if (this.detailsToFontMap.containsKey(fnDet)) {
            return this.detailsToFontMap.get(fnDet);
        }
        Font font = null;
        if (usage.equals((Object)Usage.SCREEN) && this.scrnFileToFontMap.containsKey(lname)) {
            font = this.scrnFileToFontMap.get(lname);
        } else if (usage.equals((Object)Usage.PRINT) && this.prnFileToFontMap.containsKey(lname)) {
            font = this.prnFileToFontMap.get(lname);
        }
        if (font == null) {
            return null;
        }
        if (size > 0) {
            font = font.deriveFont((float)size * 1.0f);
        }
        if (style > 0) {
            font = FontStyles.deriveFont(font, style);
        }
        this.detailsToFontMap.put(fnDet, font);
        return font;
    }

    private Font getFontForLocale(String localeStr, int style, int size, Usage usage) {
        FontMeta fm = this.getFontMeta(localeStr, usage);
        if (fm == null) {
            return null;
        }
        if (fm.getUsageEnumerated().equals((Object)usage)) {
            return this.getFont(fm.getFileName(), style, size, usage);
        }
        return null;
    }
}

