/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.fontman;

import in.gov.uidai.swing.fontman.Usage;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.commons.lang.StringUtils;

public class FontMeta {
    private String fileName;
    private float size = 12.0f;
    private String style;
    private String locale;
    private Usage usage;

    public String getFileName() {
        return this.fileName;
    }

    @XmlAttribute(name="file", required=true)
    public void setFileName(String file) {
        this.fileName = file;
    }

    public float getSize() {
        return this.size;
    }

    @XmlAttribute(name="size")
    public void setSize(float size) {
        this.size = size;
    }

    @XmlAttribute(name="style")
    public void setStyle(String style) {
        this.style = style;
    }

    public String getLocale() {
        return this.locale;
    }

    @XmlAttribute(name="locale")
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Usage getUsageEnumerated() {
        return this.usage;
    }

    @XmlAttribute(name="usage", required=true)
    public void setUsage(String usage) {
        this.usage = Usage.valueOf(usage.toUpperCase(Locale.getDefault()));
    }

    public Font applyStyle(Font font) {
        if (StringUtils.isBlank((String)this.style)) {
            return font;
        }
        String[] parts = this.style.split("|");
        HashMap fontAttrib = new HashMap(font.getAttributes());
        for (String part : parts) {
            if ((part = part.trim()).equalsIgnoreCase("condensed")) {
                fontAttrib.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
            }
            if (part.equalsIgnoreCase("semi-condensed")) {
                fontAttrib.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
            }
            if (part.equalsIgnoreCase("extended")) {
                fontAttrib.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
            }
            if (part.equalsIgnoreCase("semi-extended")) {
                fontAttrib.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
            }
            if (part.equalsIgnoreCase("kerning")) {
                fontAttrib.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
            }
            if (part.equalsIgnoreCase("loose-tracking")) {
                fontAttrib.put(TextAttribute.TRACKING, TextAttribute.TRACKING_LOOSE);
            }
            if (part.equalsIgnoreCase("tight-tracking")) {
                fontAttrib.put(TextAttribute.TRACKING, TextAttribute.TRACKING_TIGHT);
            }
            if (part.equalsIgnoreCase("bold")) {
                fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (part.equalsIgnoreCase("demi-bold")) {
                fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMIBOLD);
            }
            if (part.equalsIgnoreCase("extra-bold")) {
                fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRABOLD);
            }
            if (part.equalsIgnoreCase("ultra-bold")) {
                fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_ULTRABOLD);
            }
            if (part.equalsIgnoreCase("light")) {
                fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            }
            if (part.equalsIgnoreCase("demi-light")) {
                fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMILIGHT);
            }
            if (part.equalsIgnoreCase("extra-light")) {
                fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT);
            }
            if (part.equalsIgnoreCase("heavy")) {
                fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_HEAVY);
            }
            if (part.equalsIgnoreCase("medium")) {
                fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_MEDIUM);
            }
            if (part.equalsIgnoreCase("ligature")) {
                fontAttrib.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
            }
            if (part.equalsIgnoreCase("italic")) {
                fontAttrib.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (part.equalsIgnoreCase("strikethrough")) {
                fontAttrib.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            if (part.equalsIgnoreCase("underline")) {
                fontAttrib.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (part.equalsIgnoreCase("superscript")) {
                fontAttrib.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
            }
            if (!part.equalsIgnoreCase("subscript")) continue;
            fontAttrib.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        fontAttrib.put(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_NONE);
        return font.deriveFont(fontAttrib);
    }
}

