/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.fontman;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;

public final class FontStyles {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int EXTRA_LIGHT = 4;
    public static final int DEMI_LIGHT = 8;
    public static final int LIGHT = 16;
    public static final int DEMI_BOLD = 32;
    public static final int EXTRA_BOLD = 64;
    public static final int ULTRA_BOLD = 128;
    public static final int STRIKETHROUGH = 256;
    public static final int UNDERLINE = 512;

    public static final Font deriveFont(Font font, int style) {
        HashMap fontAttrib = new HashMap(font.getAttributes());
        if (style == 0) {
            return font;
        }
        if ((style & 1) == 1) {
            fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((style & 2) == 2) {
            fontAttrib.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if ((style & 4) == 4) {
            fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT);
        }
        if ((style & 8) == 8) {
            fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMILIGHT);
        }
        if ((style & 0x10) == 16) {
            fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
        }
        if ((style & 0x20) == 32) {
            fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMIBOLD);
        }
        if ((style & 0x40) == 64) {
            fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRABOLD);
        }
        if ((style & 0x80) == 128) {
            fontAttrib.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_ULTRABOLD);
        }
        if ((style & 0x200) == 512) {
            fontAttrib.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if ((style & 0x100) == 256) {
            fontAttrib.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return font.deriveFont(fontAttrib);
    }
}

