/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.l10n;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.swing.fontman.FontManager;
import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.StringUtils;

public class L10nDecorator {
    private final IResourceBundleContext rbCtxt;
    private final boolean localizeFlag;
    private Font defaultFont;
    private boolean defaultParams;

    public L10nDecorator(IResourceBundleContext ctxt, boolean localize) {
        this.rbCtxt = ctxt;
        this.localizeFlag = localize;
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
    }

    public void followDefaultFontParameters(boolean flag) {
        this.defaultParams = flag;
    }

    public void localize(JLabel label, Object key, Object ... arguments) {
        FontSource fontSource = label::getFont;
        Decoration decoration = this.getDecoration(fontSource, key, this.defaultFont, arguments);
        if (decoration.font != null) {
            label.setFont(decoration.font);
        }
        if (this.shouldSkip(decoration.text)) {
            return;
        }
        label.setText(decoration.text);
    }

    public void localize(AbstractButton button, Object key, Object ... arguments) {
        FontSource fontSource = button::getFont;
        Decoration decoration = this.getDecoration(fontSource, key, this.defaultFont, arguments);
        if (decoration.font != null) {
            button.setFont(decoration.font);
        }
        if (this.shouldSkip(decoration.text)) {
            return;
        }
        button.setText(decoration.text);
    }

    public void localize(JOptionPane optPane, Object key, Object ... arguments) {
        Decoration decoration = this.getDecoration(null, key, null, arguments);
        if (this.shouldSkip(decoration.text)) {
            return;
        }
        JLabel label = new JLabel(decoration.text);
        if (decoration.font != null) {
            label.setFont(decoration.font);
        }
        optPane.setMessage(label);
    }

    public void localize(TitledBorder border, Object key, Object ... arguments) {
        Decoration decoration = this.getDecoration(null, key, null, arguments);
        if (this.shouldSkip(decoration.text)) {
            return;
        }
        border.setTitle(decoration.text);
        if (decoration.font != null) {
            border.setTitleFont(decoration.font);
        }
    }

    public void localizeToolTip(JComponent comp, Object key, Object ... arguments) {
        Decoration decoration = this.getDecoration(null, key, null, arguments);
        if (this.shouldSkip(decoration.text)) {
            return;
        }
        if (decoration.font != null) {
            StringBuilder sb = new StringBuilder("<html>");
            sb.append("<span style=\"font-family:").append(decoration.font.getFamily()).append("; font-size:11px").append("\">");
            sb.append(decoration.text);
            comp.setToolTipText(sb.toString());
        } else {
            comp.setToolTipText(decoration.text);
        }
    }

    private Decoration getDecoration(FontSource fontSource, Object key, Font defaultFont, Object[] arguments) {
        Decoration decoration = new Decoration();
        if (this.localizeFlag) {
            decoration.text = this.rbCtxt.getLocaleMessage(key, arguments);
            if (this.defaultParams && fontSource != null) {
                int size = fontSource.getFont().getSize();
                int style = fontSource.getFont().getStyle();
                decoration.font = FontManager.getInst().getScreenFontForLocale(this.rbCtxt.getLocale().toString(), style, size);
            } else {
                decoration.font = FontManager.getInst().getScreenFontForLocale(this.rbCtxt.getLocale());
            }
            if (this.shouldSkip(decoration.text)) {
                decoration.text = this.rbCtxt.getMessage(key, arguments);
                decoration.font = defaultFont;
            }
        } else {
            decoration.text = this.rbCtxt.getMessage(key, arguments);
            decoration.font = defaultFont;
        }
        return decoration;
    }

    private boolean shouldSkip(String text) {
        return StringUtils.startsWith((String)text, (String)"!") && StringUtils.endsWith((String)text, (String)"!");
    }

    static class Decoration {
        String text;
        Font font;

        Decoration() {
        }
    }

    static interface FontSource {
        public Font getFont();
    }
}

