/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.swing.l10n;

import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.popup.MessagePopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class L10nOptionPane {
    private final List<Object> compList = new ArrayList<Object>();
    private Object message;
    private Object[] arguments;
    private int messageType;
    private int optionType;
    private Icon icon;
    private Object[] options;
    private Object initialValue;
    private String title;
    private Image winIcon;
    private L10nDecorator ldeco;
    private MessagePopup messagePopup;

    private L10nOptionPane() {
    }

    public static L10nOptionPane create(L10nDecorator deco) {
        L10nOptionPane result = new L10nOptionPane();
        result.ldeco = deco;
        return result;
    }

    public L10nOptionPane winIcon(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            this.winIcon = new ImageIcon(cl.getResource(path)).getImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public L10nOptionPane message(Object msg, Object ... arguments) {
        this.message = msg;
        this.arguments = arguments;
        return this;
    }

    public L10nOptionPane components(Object ... components) {
        this.compList.addAll(Arrays.asList(components));
        return this;
    }

    public L10nOptionPane messageType(int type) {
        this.messageType = type;
        return this;
    }

    public L10nOptionPane optionType(int type) {
        this.optionType = type;
        return this;
    }

    public L10nOptionPane icon(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            this.icon = new ImageIcon(cl.getResource(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public L10nOptionPane options(Object ... opts) {
        this.options = opts;
        return this;
    }

    public L10nOptionPane initialValue(Object value) {
        this.initialValue = value;
        return this;
    }

    public L10nOptionPane title(String value) {
        this.title = value;
        return this;
    }

    public Object show(Component parent) {
        JOptionPane opt = null;
        if (!this.compList.isEmpty()) {
            if (this.message != null) {
                JLabel label = new JLabel(this.message.toString());
                if (this.ldeco != null) {
                    this.ldeco.localize(label, this.message, this.arguments);
                }
                this.compList.add(0, label);
            }
            opt = new JOptionPane(this.compList.toArray(), this.messageType, this.optionType, this.icon, this.options, this.initialValue);
        } else {
            opt = new JOptionPane(this.message, this.messageType, this.optionType, this.icon, this.options, this.initialValue);
            if (this.ldeco != null && this.message != null) {
                this.ldeco.localize(opt, (Object)this.message.toString(), this.arguments);
            }
        }
        this.localizeRecursive(opt);
        JDialog dlg = opt.createDialog(parent, this.title);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - dlg.getWidth()) / 2;
        int y = (screenSize.height - dlg.getHeight()) / 2;
        dlg.setLocation(x, y);
        dlg.setIconImage(this.winIcon);
        dlg.setAlwaysOnTop(true);
        dlg.setVisible(true);
        Object result = opt.getValue();
        return result;
    }

    public void showErrorPopupUC(Component parent) {
        this.messagePopup = new MessagePopup(parent);
        String transactionId = this.compList.get(2) == null ? "" : this.compList.get(2).toString();
        this.messagePopup.createMessage(this.compList.get(0).toString(), this.compList.get(1).toString(), transactionId, this.winIcon);
    }

    public void showSimpleErrorPopupUC(Component parent, Object message) {
        this.messagePopup = new MessagePopup(parent);
        this.messagePopup.createErrorMessage((String)message, this.winIcon);
    }

    public void showWarningPopupUC(Object msg, Component parent) {
        this.messagePopup = new MessagePopup(parent);
        this.messagePopup.createWarningMessage(this.message.toString(), this.winIcon);
    }

    public void showInfoPopupUC() {
        this.messagePopup = new MessagePopup(null);
        this.messagePopup.createInfoMessage(this.message.toString(), this.winIcon);
    }

    public Object showInfoPopupUCTest(Component parent, String msg) {
        JOptionPane op = new JOptionPane(this.message, this.messageType, this.optionType, this.icon, this.options, this.initialValue);
        this.messagePopup = new MessagePopup(parent);
        this.messagePopup.createInfoMessageTest(msg, op);
        return this.messagePopup.getOpValue();
    }

    private void localizeRecursive(JComponent root) {
        Component[] components;
        for (Component comp : components = root.getComponents()) {
            if (comp instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)comp;
                this.ldeco.localize(button, (Object)button.getText(), new Object[0]);
                continue;
            }
            if (!(comp instanceof JComponent)) continue;
            this.localizeRecursive((JComponent)comp);
        }
    }
}

